/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.block.BlockBase;
import epicsquid.mysticallib.model.CustomModelBlock;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.block.BakedModelSlant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlantBase
extends BlockBase {
    public static float box_precision = 0.125f;
    @Nonnull
    public static Map<Integer, List<AxisAlignedBB>> boxes = new HashMap<Integer, List<AxisAlignedBB>>();
    public static final PropertyInteger VERT = PropertyInteger.func_177719_a((String)"vert", (int)0, (int)2);
    public static final PropertyInteger DIR = PropertyInteger.func_177719_a((String)"dir", (int)0, (int)3);
    @Nullable
    protected IBlockState parent = null;

    public BlockSlantBase(@Nonnull Material mat, @Nonnull SoundType type, float hardness, @Nonnull String name) {
        super(mat, type, hardness, name);
        this.func_149713_g(0);
        this.setOpacity(false);
        this.field_149787_q = false;
        this.setModelCustom(true);
    }

    public BlockSlantBase(@Nonnull IBlockState parent, @Nonnull SoundType type, float hardness, @Nonnull String name) {
        super(parent.func_185904_a(), type, hardness, name);
        this.func_149713_g(0);
        this.setOpacity(false);
        this.field_149787_q = false;
        this.parent = parent;
        this.setModelCustom(true);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        switch ((Integer)state.func_177229_b((IProperty)VERT)) {
            case 0: {
                return face != EnumFacing.UP && face.func_176734_d().func_176745_a() != (Integer)state.func_177229_b((IProperty)DIR) + 2 ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
            }
            case 1: {
                switch ((Integer)state.func_177229_b((IProperty)DIR)) {
                    case 0: {
                        return face != EnumFacing.EAST && face != EnumFacing.SOUTH ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                    }
                    case 1: {
                        return face != EnumFacing.WEST && face != EnumFacing.SOUTH ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                    }
                    case 2: {
                        return face != EnumFacing.WEST && face != EnumFacing.NORTH ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                    }
                    case 3: {
                        return face != EnumFacing.EAST && face != EnumFacing.NORTH ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                    }
                }
                break;
            }
            case 2: {
                return face != EnumFacing.DOWN && face.func_176734_d().func_176745_a() != (Integer)state.func_177229_b((IProperty)DIR) + 2 ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
            }
        }
        return BlockFaceShape.SOLID;
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing face, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            world.func_180501_a(pos, state.func_185907_a(Rotation.COUNTERCLOCKWISE_90), 8);
            return true;
        }
        return false;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VERT, DIR});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VERT, (Comparable)Integer.valueOf(meta / 4)).func_177226_a((IProperty)DIR, (Comparable)Integer.valueOf(meta % 4));
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, @Nonnull Rotation rot) {
        if ((Integer)state.func_177229_b((IProperty)VERT) == 1) {
            int newDir = ((Integer)state.func_177229_b((IProperty)DIR) + rot.ordinal()) % 4;
            return state.func_177226_a((IProperty)DIR, (Comparable)Integer.valueOf(newDir));
        }
        EnumFacing face = EnumFacing.func_82600_a((int)((Integer)state.func_177229_b((IProperty)DIR) + 2));
        return state.func_177226_a((IProperty)DIR, (Comparable)Integer.valueOf(rot.func_185831_a(face).func_176745_a() - 2));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VERT) * 4 + (Integer)state.func_177229_b((IProperty)DIR);
    }

    public boolean func_176225_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return true;
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return false;
    }

    public void func_185477_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nonnull Entity entity, boolean advanced) {
        ArrayList<AxisAlignedBB> temp;
        block33: {
            float i;
            int dir;
            int vert;
            block34: {
                block32: {
                    temp = new ArrayList<AxisAlignedBB>();
                    vert = (Integer)state.func_177229_b((IProperty)VERT);
                    dir = (Integer)state.func_177229_b((IProperty)DIR);
                    if (vert != 0) break block32;
                    switch (dir) {
                        case 0: {
                            for (i = 0.0f; i < 1.0f; i += box_precision) {
                                temp.add(new AxisAlignedBB(0.0, (double)i, 0.0, 1.0, (double)(i + box_precision), 1.0 - (double)i));
                            }
                            break block33;
                        }
                        case 1: {
                            for (i = 0.0f; i < 1.0f; i += box_precision) {
                                temp.add(new AxisAlignedBB(0.0, (double)i, (double)i, 1.0, (double)(i + box_precision), 1.0));
                            }
                            break block33;
                        }
                        case 2: {
                            for (i = 0.0f; i < 1.0f; i += box_precision) {
                                temp.add(new AxisAlignedBB(0.0, (double)i, 0.0, 1.0 - (double)i, (double)(i + box_precision), 1.0));
                            }
                            break block33;
                        }
                        case 3: {
                            for (i = 0.0f; i < 1.0f; i += box_precision) {
                                temp.add(new AxisAlignedBB((double)i, (double)i, 0.0, 1.0, (double)(i + box_precision), 1.0));
                            }
                            break;
                        }
                    }
                    break block33;
                }
                if (vert != 1) break block34;
                switch (dir) {
                    case 0: {
                        for (i = 0.0f; i < 1.0f; i += box_precision) {
                            temp.add(new AxisAlignedBB(0.0, 0.0, (double)i, 1.0 - (double)i, 1.0, (double)(i + box_precision)));
                        }
                        break block33;
                    }
                    case 1: {
                        for (i = 0.0f; i < 1.0f; i += box_precision) {
                            temp.add(new AxisAlignedBB((double)i, 0.0, (double)i, 1.0, 1.0, (double)(i + box_precision)));
                        }
                        break block33;
                    }
                    case 2: {
                        for (i = 0.0f; i < 1.0f; i += box_precision) {
                            temp.add(new AxisAlignedBB((double)i, 0.0, 1.0 - (double)i, 1.0, 1.0, 1.0 - (double)box_precision - (double)i));
                        }
                        break block33;
                    }
                    case 3: {
                        for (i = 0.0f; i < 1.0f; i += box_precision) {
                            temp.add(new AxisAlignedBB(0.0, 0.0, 1.0 - (double)i, 1.0 - (double)i, 1.0, 1.0 - (double)box_precision - (double)i));
                        }
                        break;
                    }
                }
                break block33;
            }
            if (vert == 2) {
                switch (dir) {
                    case 0: {
                        for (i = 0.0f; i < 1.0f; i += box_precision) {
                            temp.add(new AxisAlignedBB(0.0, 1.0 - (double)i, 0.0, 1.0, 1.0 - (double)box_precision - (double)i, 1.0 - (double)i));
                        }
                        break;
                    }
                    case 1: {
                        for (i = 0.0f; i < 1.0f; i += box_precision) {
                            temp.add(new AxisAlignedBB(0.0, 1.0 - (double)i, (double)i, 1.0, 1.0 - (double)box_precision - (double)i, 1.0));
                        }
                        break;
                    }
                    case 2: {
                        for (i = 0.0f; i < 1.0f; i += box_precision) {
                            temp.add(new AxisAlignedBB(0.0, 1.0 - (double)i, 0.0, 1.0 - (double)i, 1.0 - (double)box_precision - (double)i, 1.0));
                        }
                        break;
                    }
                    case 3: {
                        for (i = 0.0f; i < 1.0f; i += box_precision) {
                            temp.add(new AxisAlignedBB((double)i, 1.0 - (double)i, 0.0, 1.0, 1.0 - (double)box_precision - (double)i, 1.0));
                        }
                        break;
                    }
                }
            }
        }
        for (AxisAlignedBB b : temp) {
            BlockSlantBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)b);
        }
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing face, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        int vert = 1;
        if (hitY > 0.0f && hitY < 1.0f && (hitX > 0.0f && hitX < 1.0f && Math.abs((double)hitY - 0.5) > Math.abs((double)hitX - 0.5) || hitZ > 0.0f && hitZ < 1.0f && Math.abs((double)hitY - 0.5) > Math.abs((double)hitZ - 0.5))) {
            vert = 1 + (int)Math.signum((double)hitY - 0.5);
        }
        if (hitY == 0.0f) {
            vert = 2;
        }
        if (hitY == 1.0f) {
            vert = 0;
        }
        int dir = 3;
        if (vert == 1) {
            if (hitX == 0.0f) {
                dir = (double)hitZ < 0.5 ? 1 : 2;
            } else if (hitZ == 0.0f) {
                dir = (double)hitX < 0.5 ? 3 : 2;
            } else if (hitX == 1.0f) {
                dir = (double)hitZ < 0.5 ? 0 : 3;
            } else if (hitZ == 1.0f) {
                dir = (double)hitX < 0.5 ? 0 : 1;
            }
        } else {
            dir = placer.func_174811_aO().func_176745_a() - 2;
        }
        return this.func_176223_P().func_177226_a((IProperty)VERT, (Comparable)Integer.valueOf(vert)).func_177226_a((IProperty)DIR, (Comparable)Integer.valueOf(dir));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel()) {
            ResourceLocation defaultTex = new ResourceLocation(this.getRegistryName().func_110624_b() + ":blocks/" + this.getRegistryName().func_110623_a());
            if (this.parent != null) {
                defaultTex = new ResourceLocation(this.parent.func_177230_c().getRegistryName().func_110624_b() + ":blocks/" + this.parent.func_177230_c().getRegistryName().func_110623_a());
            }
            CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
            CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#handlers"), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
        }
    }

    @Override
    @Nullable
    protected IBlockState getParentState() {
        return this.parent;
    }

    @Override
    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass() {
        return BakedModelSlant.class;
    }
}

