/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.component.multiblock;

import io.github.phantamanta44.libnine.component.multiblock.IMultiBlockUnit;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockConnectable;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockCore;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockType;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class MultiBlockComponent<T extends IMultiBlockUnit<T>>
extends MultiBlockConnectable<T> {
    @Nullable
    private BlockPos corePos = null;
    @Nullable
    private MultiBlockCore<T> cachedCore = null;
    private final List<Runnable> connectionStatusCallbacks = new ArrayList<Runnable>();

    public MultiBlockComponent(T component, MultiBlockType<T> type) {
        super(component, type);
    }

    @Override
    @Nullable
    public MultiBlockCore<T> getCore() {
        if (this.cachedCore != null) {
            this.corePos = null;
            return this.cachedCore;
        }
        if (this.corePos != null) {
            this.cachedCore = (MultiBlockCore)this.getAtPos(this.corePos);
            this.corePos = null;
        }
        return this.cachedCore;
    }

    @Override
    public void setCore(@Nullable MultiBlockCore<T> core) {
        this.cachedCore = core;
        this.postConnectionStatusChange();
    }

    public boolean isConnected() {
        return this.getCore() != null;
    }

    public void onConnectionStatusChange(Runnable callback) {
        this.connectionStatusCallbacks.add(callback);
    }

    private void postConnectionStatusChange() {
        this.connectionStatusCallbacks.forEach(Runnable::run);
    }

    @Override
    public void disconnect() {
        MultiBlockCore<T> core = this.getCore();
        if (core != null) {
            core.disconnect();
        }
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        super.serBytes(data);
        MultiBlockCore<T> core = this.getCore();
        if (core != null) {
            data.writeBool(true).writeBlockPos(core.getUnit().getWorldPos().getPos());
        } else {
            data.writeBool(false);
        }
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        super.deserBytes(data);
        this.cachedCore = null;
        if (data.readBool()) {
            this.corePos = data.readBlockPos();
        }
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        super.serNBT(tag);
        MultiBlockCore<T> core = this.getCore();
        if (core != null) {
            tag.func_74782_a("CorePos", (NBTBase)NBTUtils.serializeBlockPos(core.getUnit().getWorldPos().getPos()));
        }
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        super.deserNBT(tag);
        this.cachedCore = null;
        if (tag.func_74764_b("CorePos")) {
            this.corePos = NBTUtils.deserializeBlockPos(tag.func_74775_l("CorePos"));
        }
    }
}

