/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.gameobject;

import io.github.phantamanta44.libnine.util.helper.OreDictUtils;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemIdentity {
    public static final ItemIdentity AIR = new ItemIdentity(Items.field_190931_a);
    private final Item item;
    private final int meta;
    @Nullable
    private final NBTTagCompound dataTag;

    public static ItemIdentity getForStack(ItemStack stack) {
        return stack.func_190926_b() ? AIR : new ItemIdentity(stack.func_77973_b(), stack.func_77960_j(), stack.func_77942_o() ? stack.func_77978_p() : null);
    }

    public ItemIdentity(Item item, int meta, @Nullable NBTTagCompound dataTag) {
        this.item = item;
        this.meta = meta;
        this.dataTag = dataTag;
    }

    public ItemIdentity(Item item, int meta) {
        this(item, meta, null);
    }

    public ItemIdentity(Item item) {
        this(item, Short.MAX_VALUE);
    }

    public Item getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    @Nullable
    public NBTTagCompound getDataTag() {
        return this.dataTag != null ? this.dataTag.func_74737_b() : null;
    }

    public boolean isAir() {
        return this.item == Items.field_190931_a;
    }

    public ItemIdentity mutate(Consumer<ItemStack> mutator) {
        ItemStack stack = this.createStack(1);
        mutator.accept(stack);
        return ItemIdentity.getForStack(stack);
    }

    public ItemStack createStack(int count) {
        if (this.isAir()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(this.item, count, this.meta == Short.MAX_VALUE ? 0 : this.meta);
        if (this.dataTag != null) {
            stack.func_77982_d(this.dataTag.func_74737_b());
        }
        return stack;
    }

    public boolean matches(ItemStack stack) {
        if (this.isAir()) {
            return stack.func_190926_b();
        }
        if (stack.func_77973_b() != this.item || this.meta != Short.MAX_VALUE && stack.func_77960_j() != this.meta) {
            return false;
        }
        return this.dataTag == null ? !stack.func_77942_o() : stack.func_77942_o() && this.dataTag.equals((Object)Objects.requireNonNull(stack.func_77978_p()));
    }

    public boolean matchesOreDict(String oreName) {
        return OreDictUtils.matchesOredict(this.createStack(1), oreName);
    }

    public int hashCode() {
        if (this.isAir()) {
            return 0;
        }
        return this.item.hashCode() * 523 ^ this.meta * 17 ^ (this.dataTag == null ? -559038737 : this.dataTag.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemIdentity)) {
            return false;
        }
        ItemIdentity o = (ItemIdentity)obj;
        return this.isAir() && o.isAir() || this.item == o.item && this.meta == o.meta && Objects.equals(this.dataTag, o.dataTag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.item.getRegistryName()).append(":").append(this.meta);
        if (this.dataTag != null) {
            sb.append(" ").append(this.dataTag);
        }
        return sb.toString();
    }
}

