/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.mixin.inventory.AccessorCraftingContainer;
import net.darkhax.bookshelf.mixin.inventory.AccessorCraftingMenu;
import net.darkhax.bookshelf.mixin.inventory.AccessorInventoryMenu;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;

public interface IInventoryHelper {
    @Nullable
    default public AbstractContainerMenu getCraftingContainer(CraftingContainer container) {
        AbstractContainerMenu abstractContainerMenu;
        if (container instanceof AccessorCraftingContainer) {
            AccessorCraftingContainer accessor = (AccessorCraftingContainer)container;
            abstractContainerMenu = accessor.bookshelf$getMenu();
        } else {
            abstractContainerMenu = null;
        }
        return abstractContainerMenu;
    }

    @Nullable
    default public Player getCraftingPlayer(Container container) {
        if (container instanceof Inventory) {
            Inventory playerInv = (Inventory)container;
            return playerInv.f_35978_;
        }
        if (container instanceof CraftingContainer) {
            CraftingContainer crafting = (CraftingContainer)container;
            AbstractContainerMenu menu = this.getCraftingContainer(crafting);
            if (menu instanceof AccessorCraftingMenu) {
                AccessorCraftingMenu accessor = (AccessorCraftingMenu)menu;
                return accessor.bookshelf$getPlayer();
            }
            if (menu instanceof AccessorInventoryMenu) {
                AccessorInventoryMenu accessor = (AccessorInventoryMenu)menu;
                return accessor.bookshelf$getOwner();
            }
        }
        return null;
    }

    default public ItemStack damageStack(ItemStack stack, int amount, @Nullable LivingEntity owner, @Nullable EquipmentSlot slot) {
        if (stack.m_41763_()) {
            if (owner != null) {
                stack.m_41622_(amount, owner, e -> {
                    if (slot != null) {
                        e.m_21166_(slot);
                    }
                });
            } else if (stack.m_41629_(amount, Constants.RANDOM, null)) {
                stack.m_41774_(1);
                stack.m_41721_(0);
            }
        }
        return stack;
    }

    default public NonNullList<ItemStack> keepDamageableItems(CraftingContainer inv, NonNullList<ItemStack> keptItems, int damageAmount) {
        Player player = this.getCraftingPlayer((Container)inv);
        Random random = player != null ? player.m_21187_() : Constants.RANDOM;
        for (int i = 0; i < keptItems.size(); ++i) {
            ItemStack stack;
            ItemStack input = inv.m_8020_(i).m_41777_();
            if (!input.m_41720_().m_41465_() && (!input.m_41782_() || !input.m_41783_().m_128471_("Unbreaking")) || (stack = this.damageStack(input, damageAmount, (LivingEntity)player, null)).m_41619_()) continue;
            keptItems.set(i, (Object)stack);
        }
        return keptItems;
    }
}

