/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.api.item.ICreativeTabBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class CreativeTabBuilderForge
implements ICreativeTabBuilder {
    private final ResourceLocation id;
    private final Set<EnchantmentCategory> enchantmentCategories = new HashSet<EnchantmentCategory>();
    private final List<Consumer<List<ItemStack>>> tabContents = new ArrayList<Consumer<List<ItemStack>>>();
    private Supplier<ItemStack> iconSupplier;

    public CreativeTabBuilderForge(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public CreativeTabBuilderForge setIconStack(Supplier<ItemStack> iconSupplier) {
        this.iconSupplier = iconSupplier;
        return this;
    }

    @Override
    public CreativeTabBuilderForge setEnchantmentCategories(EnchantmentCategory ... categories) {
        this.enchantmentCategories.addAll(Arrays.asList(categories));
        return this;
    }

    @Override
    public CreativeTabBuilderForge setTabContents(Consumer<List<ItemStack>> contentSupplier) {
        this.tabContents.add(contentSupplier);
        return this;
    }

    @Override
    public CreativeModeTab build() {
        CreativeModeTab tab = new CreativeModeTab(this.id.m_135827_() + "." + this.id.m_135815_()){

            public ItemStack m_6976_() {
                return CreativeTabBuilderForge.this.iconSupplier.get();
            }

            public void m_6151_(NonNullList<ItemStack> stackContents) {
                for (Consumer<List<ItemStack>> contentSupplier : CreativeTabBuilderForge.this.tabContents) {
                    contentSupplier.accept((List<ItemStack>)stackContents);
                }
                super.m_6151_(stackContents);
            }
        };
        tab.m_40781_(this.enchantmentCategories.toArray(new EnchantmentCategory[0]));
        return tab;
    }

    @Override
    public ResourceLocation getTabId() {
        return this.id;
    }
}

