/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockStandardDrawers
extends BlockDrawers {
    public BlockStandardDrawers(int drawerCount, boolean halfDepth, int storageUnits, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    public BlockStandardDrawers(int drawerCount, boolean halfDepth, BlockBehaviour.Properties properties) {
        super(drawerCount, halfDepth, BlockStandardDrawers.calcUnits(drawerCount, halfDepth), properties);
    }

    private static int calcUnits(int drawerCount, boolean halfDepth) {
        return halfDepth ? 4 / drawerCount : 8 / drawerCount;
    }

    @Override
    protected int getDrawerSlot(Direction side, Vec3 hit) {
        if (this.getDrawerCount() == 1) {
            return 0;
        }
        if (this.getDrawerCount() == 2) {
            return this.hitTop(hit.f_82480_) ? 0 : 1;
        }
        if (this.hitLeft(side, hit.f_82479_, hit.f_82481_)) {
            return this.hitTop(hit.f_82480_) ? 0 : 2;
        }
        return this.hitTop(hit.f_82480_) ? 1 : 3;
    }

    public TileEntityDrawers newBlockEntity(BlockPos pos, BlockState state) {
        return TileEntityDrawersStandard.createEntity(this.getDrawerCount(), pos, state);
    }
}

