/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class CompTierRegistry {
    private List<Record> records = new ArrayList<Record>();
    private List<String> pendingRules = new ArrayList<String>();
    private boolean initialized;

    public void initialize() {
        this.initialized = true;
        if (((Boolean)CommonConfig.GENERAL.enableExtraCompactingRules.get()).booleanValue()) {
            this.register(new ItemStack((ItemLike)Blocks.f_50129_), new ItemStack((ItemLike)Items.f_42461_), 4);
            this.register(new ItemStack((ItemLike)Blocks.f_50127_), new ItemStack((ItemLike)Items.f_42452_), 4);
            this.register(new ItemStack((ItemLike)Blocks.f_50141_), new ItemStack((ItemLike)Items.f_42525_), 4);
            this.register(new ItemStack((ItemLike)Blocks.f_50076_), new ItemStack((ItemLike)Items.f_42460_), 4);
            this.register(new ItemStack((ItemLike)Blocks.f_50197_), new ItemStack((ItemLike)Items.f_42691_), 4);
            this.register(new ItemStack((ItemLike)Blocks.f_50451_), new ItemStack((ItemLike)Items.f_42588_), 9);
            this.register(new ItemStack((ItemLike)Blocks.f_50333_), new ItemStack((ItemLike)Items.f_42692_), 4);
            this.register(new ItemStack((ItemLike)Blocks.f_50186_), new ItemStack((ItemLike)Items.f_42575_), 9);
            if (!ModList.get().isLoaded("extrautilities")) {
                this.register(new ItemStack((ItemLike)Blocks.f_50062_), new ItemStack((ItemLike)Blocks.f_49992_), 4);
                this.register(new ItemStack((ItemLike)Blocks.f_50394_), new ItemStack((ItemLike)Blocks.f_49993_, 1), 4);
            }
        }
        CommonConfig.onLoad(() -> ((List)CommonConfig.GENERAL.compRules.get()).forEach(this::register));
        for (String rule : this.pendingRules) {
            this.register(rule);
        }
        this.pendingRules = null;
    }

    public boolean register(@Nonnull ItemStack upper, @Nonnull ItemStack lower, int convRate) {
        if (upper.m_41619_() || lower.m_41619_()) {
            return false;
        }
        this.unregisterUpperTarget(upper);
        this.unregisterLowerTarget(lower);
        Record r = new Record(upper.m_41777_(), lower.m_41777_(), convRate);
        r.upper.m_41764_(1);
        r.lower.m_41764_(1);
        this.records.add(r);
        StorageDrawers.log.info("New compacting rule " + convRate + " " + lower.m_41720_().toString() + " = 1 " + upper.m_41720_().toString());
        return true;
    }

    public static boolean validateRuleSyntax(String rule) {
        String[] parts = rule.split("\\s*,\\s*");
        if (parts.length != 3) {
            return false;
        }
        ResourceLocation upperResource = ResourceLocation.m_135820_((String)parts[0]);
        ResourceLocation lowerResource = ResourceLocation.m_135820_((String)parts[1]);
        if (upperResource == null || lowerResource == null) {
            return false;
        }
        try {
            int conv = Integer.parseInt(parts[2]);
            return conv >= 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void register(List<String> rules) {
        rules.forEach(this::register);
    }

    public boolean register(String rule) {
        if (!this.initialized) {
            this.pendingRules.add(rule);
            return true;
        }
        String[] parts = rule.split("\\s*,\\s*");
        if (parts.length != 3) {
            return false;
        }
        ResourceLocation upperResource = new ResourceLocation(parts[0]);
        Item upperItem = (Item)ForgeRegistries.ITEMS.getValue(upperResource);
        ResourceLocation lowerResource = new ResourceLocation(parts[1]);
        Item lowerItem = (Item)ForgeRegistries.ITEMS.getValue(lowerResource);
        if (upperItem == null || lowerItem == null) {
            return false;
        }
        try {
            int conv = Integer.parseInt(parts[2]);
            return this.register(new ItemStack((ItemLike)upperItem), new ItemStack((ItemLike)lowerItem), conv);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean unregisterUpperTarget(@Nonnull ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)r.upper)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public boolean unregisterLowerTarget(@Nonnull ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)r.lower)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public Record findHigherTier(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Record r : this.records) {
            if (!stack.m_41656_(r.lower) || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)r.lower)) continue;
            return r;
        }
        return null;
    }

    public Record findLowerTier(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Record r : this.records) {
            if (!stack.m_41656_(r.upper) || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)r.upper)) continue;
            return r;
        }
        return null;
    }

    public class Record {
        @Nonnull
        public final ItemStack upper;
        @Nonnull
        public final ItemStack lower;
        public final int convRate;

        public Record(@Nonnull ItemStack upper, ItemStack lower, int convRate) {
            this.upper = upper;
            this.lower = lower;
            this.convRate = convRate;
        }
    }
}

