/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SlotDrawer
extends Slot {
    private static Container emptyInventory = new EmptyInventory();
    private ContainerDrawers container;
    private final IDrawerGroup group;
    private final IDrawer drawer;

    public SlotDrawer(ContainerDrawers container, IDrawerGroup drawerGroup, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.container = container;
        this.group = drawerGroup;
        this.drawer = this.group.getDrawer(index);
    }

    public boolean m_5857_(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && this.drawer.canItemBeStored(stack);
    }

    @Nonnull
    public ItemStack m_7993_() {
        ItemStack stack = ItemStackHelper.encodeItemStack(this.drawer.getStoredItemPrototype(), this.drawer.getStoredItemCount());
        this.container.setLastAccessedItem(stack);
        return stack;
    }

    public void m_5852_(@Nonnull ItemStack stack) {
        IDrawer target = this.drawer.setStoredItem(stack);
        stack = ItemStackHelper.decodeItemStack(stack);
        target.setStoredItemCount(stack.m_41613_());
    }

    public void m_40234_(@Nonnull ItemStack p_75220_1_, @Nonnull ItemStack p_75220_2_) {
    }

    public int m_5866_(@Nonnull ItemStack stack) {
        return Math.min(stack.m_41741_(), this.drawer.getRemainingCapacity());
    }

    public boolean m_8010_(Player playerIn) {
        return false;
    }

    @Nonnull
    public ItemStack m_6201_(int amount) {
        int withdraw = Math.min(amount, this.drawer.getStoredItemCount());
        this.drawer.setStoredItemCount(withdraw);
        ItemStack stack = this.drawer.getStoredItemPrototype().m_41777_();
        stack.m_41764_(this.drawer.getStoredItemCount() - withdraw);
        return stack;
    }

    public IDrawerGroup getDrawerGroup() {
        return this.group;
    }

    public boolean isSameInventory(Slot other) {
        return other instanceof SlotDrawer && ((SlotDrawer)other).getDrawerGroup() == this.group;
    }

    static class EmptyInventory
    extends SimpleContainer
    implements WorldlyContainer {
        public EmptyInventory() {
            super(0);
        }

        public int[] m_7071_(Direction side) {
            return new int[0];
        }

        public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
            return false;
        }

        public boolean m_7157_(int index, ItemStack stack, Direction direction) {
            return false;
        }
    }
}

