/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.mojang.authlib.GameProfile;
import java.util.TreeSet;
import journeymap.client.JourneymapClient;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ServerLevelData;

public class CmdTeleportWaypoint {
    final Minecraft mc = Minecraft.m_91087_();
    final Waypoint waypoint;

    public CmdTeleportWaypoint(Waypoint waypoint) {
        this.waypoint = waypoint;
    }

    public static boolean isPermitted(Minecraft mc) {
        if (mc.m_91092_() != null) {
            IntegratedServer mcServer = mc.m_91092_();
            PlayerList configurationManager = null;
            GameProfile profile = null;
            try {
                profile = new GameProfile(mc.f_91074_.m_142081_(), mc.f_91074_.m_7755_().getString());
                configurationManager = mcServer.m_6846_();
                Journeymap.getLogger().debug("integrated server not null, can send commands: " + configurationManager.m_11303_(profile) + " is tp enabled: " + JourneymapClient.getInstance().getStateHandler().isTeleportEnabled());
                return configurationManager.m_11303_(profile) || JourneymapClient.getInstance().getStateHandler().isTeleportEnabled();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (profile != null && configurationManager != null) {
                        Journeymap.getLogger().debug("Some Error happened: " + mcServer.m_129792_() + " : " + ((ServerLevelData)mcServer.m_129880_(mc.f_91074_.f_19853_.m_46472_()).m_6106_()).m_5468_() + " : " + mcServer.m_129791_().equalsIgnoreCase(profile.getName()));
                        return mcServer.m_129792_() && ((ServerLevelData)mcServer.m_129880_(mc.f_91074_.f_19853_.m_46472_()).m_6106_()).m_5468_() && mcServer.m_129791_().equalsIgnoreCase(profile.getName());
                    }
                    Journeymap.getLogger().warn("Failed to check teleport permission both ways: " + LogFormatter.toString(e) + ", and profile or configManager were null.");
                }
                catch (Exception e2) {
                    Journeymap.getLogger().warn("Failed to check teleport permission. Both ways failed: " + LogFormatter.toString(e) + ", and " + LogFormatter.toString(e2));
                }
            }
        }
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection()) {
            Journeymap.getLogger().debug("On a server with JM returning: " + JourneymapClient.getInstance().getStateHandler().isTeleportEnabled());
            return JourneymapClient.getInstance().getStateHandler().isTeleportEnabled();
        }
        Journeymap.getLogger().debug("On a server without JM returning true by default");
        return true;
    }

    public void run() {
        double x = this.waypoint.getRawCenterX();
        double z = this.waypoint.getRawCenterZ();
        TreeSet dims = (TreeSet)this.waypoint.getDimensions();
        String dim = this.mc.f_91074_.f_19853_.m_46472_().m_135782_().toString();
        if (!dims.isEmpty()) {
            dim = dims.stream().filter(d -> this.mc.f_91074_.f_19853_.m_46472_().equals(DimensionHelper.getWorldKeyForName(d))).findFirst().orElse((String)dims.first());
        }
        if (Level.f_46429_.equals(DimensionHelper.getWorldKeyForName(dim)) && Level.f_46429_.equals((Object)this.mc.f_91074_.f_19853_.m_46472_())) {
            x = this.waypoint.getBlockCenteredX();
            z = this.waypoint.getBlockCenteredZ();
        }
        if (Level.f_46429_.equals(DimensionHelper.getWorldKeyForName(dim)) && !Level.f_46429_.equals((Object)this.mc.f_91074_.f_19853_.m_46472_())) {
            x = (double)((int)x >> 3) + (x > 0.0 ? 0.5 : -0.5);
            z = (double)((int)z >> 3) + (z > 0.0 ? 0.5 : -0.5);
        }
        CmdTeleportWaypoint.teleport(x, this.waypoint.getY(), z, dim);
    }

    public static void teleport(BlockPos pos, ResourceKey<Level> dim) {
        CmdTeleportWaypoint.teleport(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dim != null ? dim.m_135782_().toString() : null);
    }

    public static void teleport(double x, int y, double z, String dim) {
        Minecraft mc = Minecraft.m_91087_();
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection() || Minecraft.m_91087_().m_91091_()) {
            JourneymapClient.getInstance().getDispatcher().sendTeleportPacket(x, y, z, dim);
        } else {
            String teleportCommand = JourneymapClient.getInstance().getWaypointProperties().teleportCommand.getAsString();
            teleportCommand = teleportCommand.replace("{name}", mc.f_91074_.m_7755_().getString()).replace("{x}", String.valueOf(x)).replace("{y}", String.valueOf(y)).replace("{z}", String.valueOf(z)).replace("{dim}", dim);
            mc.f_91074_.m_108739_(teleportCommand);
        }
    }
}

