/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.registry.IOwnedRegistryEntries;
import net.darkhax.bookshelf.api.registry.IRegistryObject;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.bookshelf.api.util.MathsHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryEntries<V>
implements IOwnedRegistryEntries<V> {
    private final CachedSupplier<Logger> logger = CachedSupplier.cache(() -> LoggerFactory.getLogger((String)this.getOwner()));
    private final String name;
    private final CachedSupplier<String> ownerId;
    private final Map<ResourceLocation, IRegistryObject<? extends V>> rawValues = new LinkedHashMap<ResourceLocation, IRegistryObject<? extends V>>();
    private final Map<ResourceLocation, V> entries = new LinkedHashMap<ResourceLocation, V>();
    private final Map<ResourceLocation, V> unmodifiableEntries = Collections.unmodifiableMap(this.entries);
    private final List<BiConsumer<ResourceLocation, IRegistryObject<? extends V>>> insertListeners = new LinkedList<BiConsumer<ResourceLocation, IRegistryObject<? extends V>>>();
    private final List<BiConsumer<ResourceLocation, V>> registryListeners = new LinkedList<BiConsumer<ResourceLocation, V>>();
    private final List<BiFunction<ResourceLocation, V, V>> wrapperFunctions = new LinkedList<BiFunction<ResourceLocation, V, V>>();
    private boolean built = false;

    public RegistryEntries(Supplier<String> idProvider, ResourceKey<?> registryKey) {
        this(idProvider, registryKey.m_135782_().toString());
    }

    public RegistryEntries(Supplier<String> idProvider, String name) {
        this.ownerId = CachedSupplier.cache(idProvider);
        this.name = name;
    }

    @Override
    public String getOwner() {
        return this.ownerId.get();
    }

    @Override
    public <VT extends V> IRegistryObject<VT> add(Supplier<VT> value, ResourceLocation id) {
        if (this.built) {
            throw new IllegalStateException("This registry has already been built. New values are not being supported. Owner=" + this.getOwner() + " id=" + id);
        }
        if (this.rawValues.containsKey(id)) {
            throw new IllegalStateException("The ID " + id + " has already been registered.");
        }
        RegistryObject registryObject = new RegistryObject(id, value);
        this.rawValues.put(id, registryObject);
        this.insertListeners.forEach(listener -> listener.accept(id, registryObject));
        return registryObject;
    }

    @Override
    public Map<ResourceLocation, V> getEntries() {
        if (!this.built) {
            throw new IllegalStateException("Attempted to access registry values before they were built. Owner=" + this.ownerId);
        }
        return this.unmodifiableEntries;
    }

    @Override
    public void addInsertListener(BiConsumer<ResourceLocation, IRegistryObject<? extends V>> listener) {
        if (this.built) {
            throw new IllegalStateException("Attempted to define insert listener after entries have already been built. Owner=" + this.ownerId);
        }
        this.insertListeners.add(listener);
    }

    @Override
    public void addRegistryListener(BiConsumer<ResourceLocation, V> listener) {
        if (this.built) {
            throw new IllegalStateException("Attempted to define registry listener after entries have already been built. Owner=" + this.ownerId);
        }
        this.registryListeners.add(listener);
    }

    @Override
    public void addRegistryWrapper(BiFunction<ResourceLocation, V, V> wrapperFunc) {
        if (this.built) {
            throw new IllegalStateException("Attempted to define registry listener after entries have already been built. Owner=" + this.ownerId);
        }
        this.wrapperFunctions.add(wrapperFunc);
    }

    @Override
    public void build(BiConsumer<ResourceLocation, V> registerFunc) {
        if (this.built) {
            this.logger.get().debug("Rebuilding entries for {}. Previous entries {}", (Object)this.ownerId.get(), (Object)this.entries.size());
        }
        this.built = true;
        this.entries.clear();
        if (!this.rawValues.isEmpty()) {
            long startTime = System.nanoTime();
            this.rawValues.forEach((? super K k, ? super V v) -> {
                Object value = this.wrapValue((ResourceLocation)k, (V)v.get());
                if (value != null) {
                    this.entries.put((ResourceLocation)k, value);
                }
                registerFunc.accept((ResourceLocation)k, (V)value);
                this.registryListeners.forEach(listener -> listener.accept(k, value));
            });
            long endTime = System.nanoTime();
            this.logger.get().debug("Built {} {} entries. Took {}.", new Object[]{this.entries.size(), this.name, MathsHelper.profileNanoTime(startTime, endTime)});
        }
    }

    private V wrapValue(ResourceLocation key, V value) {
        for (BiFunction<ResourceLocation, V, V> wrapper : this.wrapperFunctions) {
            value = wrapper.apply(key, value);
        }
        return value;
    }

    @Override
    public Iterator<V> iterator() {
        return this.getEntries().values().iterator();
    }
}

