/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.rule.resolver;

import java.util.Iterator;
import xaero.common.category.FilterObjectCategory;
import xaero.common.category.rule.ObjectCategoryExcludeList;
import xaero.common.category.rule.ObjectCategoryIncludeList;
import xaero.common.category.rule.ObjectCategoryRule;

public final class ObjectCategoryRuleResolver {
    private ObjectCategoryRuleResolver() {
    }

    public <E, P, S, C extends FilterObjectCategory<E, P, S, ?, C>> C resolve(C category, E element, P context) {
        ObjectCategoryRule<E, P> baseRule = category.getBaseRule();
        ObjectCategoryIncludeList<E, S> includeList = category.getIncludeList();
        ObjectCategoryExcludeList<E, S> excludeList = category.getExcludeList();
        if ((baseRule.isFollowedBy(element, context) || includeList.isFollowedBy(element, (Object)context)) && excludeList.isFollowedBy(element, (Object)context)) {
            Iterator subCategoryIterator = category.getDirectSubCategoryIterator();
            while (subCategoryIterator.hasNext()) {
                FilterObjectCategory subCategory = (FilterObjectCategory)subCategoryIterator.next();
                FilterObjectCategory subResolve = this.resolve(subCategory, element, context);
                if (subResolve == null) continue;
                return (C)subResolve;
            }
            return category;
        }
        return null;
    }

    public static final class Builder {
        private Builder() {
        }

        public Builder setDefault() {
            return this;
        }

        public ObjectCategoryRuleResolver build() {
            return new ObjectCategoryRuleResolver();
        }

        public static Builder getDefault() {
            return new Builder().setDefault();
        }
    }
}

