/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.resource.ShaderResourceReloadListener;

public class ModEvents {
    private IXaeroMinimap modMain;

    public ModEvents(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleTextureStitchEventPost(TextureStitchEvent.Post event) {
        InterfaceManager interfaceManager;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            minimapSession.getMinimapProcessor().getMinimapWriter().setClearBlockColours(true);
            minimapSession.getMinimapProcessor().getMinimapWriter().resetShortBlocks();
        }
        if ((interfaceManager = this.modMain.getInterfaces()) != null) {
            interfaceManager.getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        InterfaceManager interfaceManager = this.modMain.getInterfaces();
        if (interfaceManager != null) {
            interfaceManager.getMinimapInterface().getMinimapFBORenderer().resetEntityIconsResources();
        }
    }

    @SubscribeEvent
    public void handleRegisterClientResourceReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ShaderResourceReloadListener());
    }
}

