/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.forge.config.ClientConfig;
import mezz.jei.ingredients.IIngredientSupplier;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.recipes.IngredientSupplierHelper;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private static IModIdHelper modIdHelper;

    private ErrorUtil() {
    }

    public static void setModIdHelper(IModIdHelper modIdHelper) {
        ErrorUtil.modIdHelper = modIdHelper;
    }

    public static <T> String getInfoFromRecipe(T recipe, IRecipeCategory<T> recipeCategory) {
        StringBuilder recipeInfoBuilder = new StringBuilder();
        String recipeName = ErrorUtil.getNameForRecipe(recipe);
        recipeInfoBuilder.append(recipeName).append(" {");
        RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
        IIngredientSupplier ingredientSupplier = IngredientSupplierHelper.getIngredientSupplier(recipe, recipeCategory, registeredIngredients);
        if (ingredientSupplier == null) {
            recipeInfoBuilder.append("\nFailed to get ingredients from recipe wrapper");
            return recipeInfoBuilder.toString();
        }
        recipeInfoBuilder.append("\n  Outputs:");
        ErrorUtil.appendRoleData(ingredientSupplier, RecipeIngredientRole.OUTPUT, recipeInfoBuilder);
        recipeInfoBuilder.append("\n  Inputs:");
        ErrorUtil.appendRoleData(ingredientSupplier, RecipeIngredientRole.INPUT, recipeInfoBuilder);
        recipeInfoBuilder.append("\n  Catalysts:");
        ErrorUtil.appendRoleData(ingredientSupplier, RecipeIngredientRole.CATALYST, recipeInfoBuilder);
        recipeInfoBuilder.append("\n}");
        return recipeInfoBuilder.toString();
    }

    private static void appendRoleData(IIngredientSupplier ingredientSupplier, RecipeIngredientRole role, StringBuilder recipeInfoBuilder) {
        ingredientSupplier.getIngredientTypes(role).forEach(ingredientType -> {
            String ingredientOutputInfo = ErrorUtil.getIngredientInfo(ingredientType, role, ingredientSupplier);
            recipeInfoBuilder.append("\n    ").append(ingredientType.getIngredientClass().getName()).append(": ").append(ingredientOutputInfo);
        });
    }

    private static <T> String getIngredientInfo(IIngredientType<T> ingredientType, RecipeIngredientRole role, IIngredientSupplier ingredients) {
        List<T> ingredientList = ingredients.getIngredientStream(ingredientType, role).toList();
        IIngredientHelper<T> ingredientHelper = Internal.getRegisteredIngredients().getIngredientHelper(ingredientType);
        Stream<String> stringStream = ingredientList.stream().map(ingredientHelper::getErrorInfo);
        return ErrorUtil.truncatedStream(stringStream, ingredientList.size(), 10).toList().toString();
    }

    public static String getNameForRecipe(Object recipe) {
        ResourceLocation registryName = null;
        if (recipe instanceof Recipe) {
            registryName = ((Recipe)recipe).m_6423_();
        } else if (recipe instanceof IForgeRegistryEntry) {
            IForgeRegistryEntry registryEntry = (IForgeRegistryEntry)recipe;
            registryName = registryEntry.getRegistryName();
        }
        if (registryName != null) {
            if (modIdHelper != null) {
                String modId = registryName.m_135827_();
                String modName = modIdHelper.getModNameForModId(modId);
                return modName + " " + registryName + " " + recipe.getClass();
            }
            return registryName + " " + recipe.getClass();
        }
        try {
            return recipe.toString();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed recipe.toString", (Throwable)e);
            return recipe.getClass().toString();
        }
    }

    public static <T> String getIngredientInfo(T ingredient, IIngredientType<T> ingredientType) {
        RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
        IIngredientHelper<T> ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    private static Stream<String> truncatedStream(Stream<String> stream, int size, int limit) {
        if (size + 1 > limit) {
            return Stream.concat(stream.limit(limit), Stream.of(String.format("<truncated to %s elements, skipped %s>", limit, size - limit)));
        }
        return stream;
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        Object itemName;
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.m_41720_();
        ResourceLocation registryName = item.getRegistryName();
        if (registryName != null) {
            itemName = registryName.toString();
        } else if (item instanceof BlockItem) {
            ResourceLocation blockRegistryName;
            Block block = ((BlockItem)item).m_40614_();
            String blockName = block == null ? "null" : ((blockRegistryName = block.getRegistryName()) != null ? blockRegistryName.toString() : block.getClass().getName());
            itemName = "BlockItem(" + blockName + ")";
        } else {
            itemName = item.getClass().getName();
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            return itemStack + " " + (String)itemName + " nbt:" + nbt;
        }
        return itemStack + " " + (String)itemName;
    }

    public static String getFluidStackInfo(FluidStack fluidStack) {
        if (fluidStack == null) {
            return "null";
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation registryName = fluid.getRegistryName();
        String fluidName = registryName != null ? registryName.toString() : fluid.getClass().getName();
        CompoundTag nbt = fluidStack.getTag();
        if (nbt != null) {
            return fluidStack + " " + fluidName + " nbt:" + nbt;
        }
        return fluidStack + " " + fluidName;
    }

    public static void checkNotEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.m_41619_()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(ItemStack itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.m_41619_()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(FluidStack fluidStack) {
        if (fluidStack == null) {
            throw new NullPointerException("FluidStack must not be null.");
        }
        if (fluidStack.isEmpty()) {
            String info = ErrorUtil.getFluidStackInfo(fluidStack);
            throw new IllegalArgumentException("FluidStack value must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length <= 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }

    public static void checkNotNull(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static void assertMainThread() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && !minecraft.m_18695_()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A JEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> ReportedException createRenderIngredientException(Throwable throwable, T ingredient) {
        RegisteredIngredients registeredIngredients = Internal.getRegisteredIngredients();
        IIngredientType ingredientType = registeredIngredients.getIngredientType(ingredient);
        IIngredientHelper ingredientHelper = registeredIngredients.getIngredientHelper(ingredientType);
        CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering ingredient");
        CrashReportCategory ingredientCategory = crashreport.m_127514_("Ingredient being rendered");
        if (modIdHelper != null) {
            ingredientCategory.m_128165_("Mod Name", () -> {
                String modId = ingredientHelper.getDisplayModId(ingredient);
                return modIdHelper.getModNameForModId(modId);
            });
        }
        ingredientCategory.m_128165_("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
        ingredientCategory.m_128165_("Display Name", () -> ingredientHelper.getDisplayName(ingredient));
        ingredientCategory.m_128165_("String Name", ingredient::toString);
        CrashReportCategory jeiCategory = crashreport.m_127514_("JEI render details");
        jeiCategory.m_128165_("Unique Id (for Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        jeiCategory.m_128165_("Ingredient Type", () -> ingredientType.getIngredientClass().toString());
        jeiCategory.m_128165_("Error Info", () -> ingredientHelper.getErrorInfo(ingredient));
        jeiCategory.m_128165_("Debug Mode Enabled", () -> Boolean.toString(ClientConfig.getInstance().isDebugModeEnabled()));
        throw new ReportedException(crashreport);
    }
}

