/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.forge;

import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.event.forge.ForgeEventHandlerManager;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.keymapping.KeyEvent;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@ParametersAreNonnullByDefault
public class ForgeKeyEvents
implements KeyEvent,
ForgeEventHandlerManager.EventHandler {
    private final KeyEventHandler keyEventHandler = new KeyEventHandler(this);

    @SubscribeEvent
    public void onGameKeyboardEvent(InputEvent.KeyInputEvent event) {
        int key = event.getKey();
        this.keyEventHandler.onGameKeyboardEvent(key);
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(ScreenEvent.KeyboardKeyPressedEvent.Post event) {
        int key = event.getKeyCode();
        boolean success = this.keyEventHandler.onGuiKeyboardEvent(event.getScreen(), key);
        event.setCanceled(success);
    }

    @SubscribeEvent
    public void onGuiMouseEvent(ScreenEvent.MouseClickedEvent.Post event) {
        int key = event.getButton();
        this.keyEventHandler.onGuiMouseEvent(key);
    }

    public KeyEventHandler getHandler() {
        return this.keyEventHandler;
    }

    @Override
    public KeyMapping register(KeyMapping keyMapping) {
        ClientRegistry.registerKeyBinding((KeyMapping)keyMapping);
        return keyMapping;
    }
}

