/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableMap;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.load.registration.SubtypeRegistration;
import mezz.jei.util.ErrorUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class SubtypeManager
implements ISubtypeManager {
    private final ImmutableMap<Item, IIngredientSubtypeInterpreter<ItemStack>> itemInterpreters;
    private final ImmutableMap<Fluid, IIngredientSubtypeInterpreter<FluidStack>> fluidInterpreters;

    public SubtypeManager(SubtypeRegistration subtypeRegistration) {
        this.itemInterpreters = subtypeRegistration.getItemInterpreters();
        this.fluidInterpreters = subtypeRegistration.getFluidInterpreters();
    }

    @Override
    @Nullable
    public String getSubtypeInfo(ItemStack itemStack, UidContext context) {
        ErrorUtil.checkNotEmpty(itemStack);
        Item item = itemStack.m_41720_();
        IIngredientSubtypeInterpreter subtypeInterpreter = (IIngredientSubtypeInterpreter)this.itemInterpreters.get((Object)item);
        if (subtypeInterpreter != null) {
            return subtypeInterpreter.apply(itemStack, context);
        }
        return null;
    }

    @Override
    @Nullable
    public String getSubtypeInfo(FluidStack fluidStack, UidContext context) {
        ErrorUtil.checkNotNull(fluidStack, "fluidStack");
        Fluid fluid = fluidStack.getFluid();
        IIngredientSubtypeInterpreter subtypeInterpreter = (IIngredientSubtypeInterpreter)this.fluidInterpreters.get((Object)fluid);
        if (subtypeInterpreter != null) {
            return subtypeInterpreter.apply(fluidStack, context);
        }
        return null;
    }
}

