/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import java.util.ArrayList;
import java.util.Collection;
import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.transfer.BasicRecipeTransferHandlerServer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class PacketRecipeTransfer
extends PacketJei {
    public final Collection<TransferOperation> transferOperations;
    public final Collection<Slot> craftingSlots;
    public final Collection<Slot> inventorySlots;
    private final boolean maxTransfer;
    private final boolean requireCompleteSets;

    public PacketRecipeTransfer(Collection<TransferOperation> transferOperations, Collection<Slot> craftingSlots, Collection<Slot> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        this.transferOperations = transferOperations;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
        this.requireCompleteSets = requireCompleteSets;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130130_(this.transferOperations.size());
        for (TransferOperation operation : this.transferOperations) {
            operation.writePacketData(buf);
        }
        buf.m_130130_(this.craftingSlots.size());
        for (Slot craftingSlot : this.craftingSlots) {
            buf.m_130130_(craftingSlot.f_40219_);
        }
        buf.m_130130_(this.inventorySlots.size());
        for (Slot inventorySlot : this.inventorySlots) {
            buf.m_130130_(inventorySlot.f_40219_);
        }
        buf.writeBoolean(this.maxTransfer);
        buf.writeBoolean(this.requireCompleteSets);
    }

    public static void readPacketData(ServerPacketData data) {
        ServerPlayer player = data.player();
        FriendlyByteBuf buf = data.buf();
        AbstractContainerMenu container = player.f_36096_;
        int transferOperationsSize = buf.m_130242_();
        ArrayList<TransferOperation> transferOperations = new ArrayList<TransferOperation>(transferOperationsSize);
        for (int i = 0; i < transferOperationsSize; ++i) {
            TransferOperation transferOperation = TransferOperation.readPacketData(buf, container);
            transferOperations.add(transferOperation);
        }
        int craftingSlotsSize = buf.m_130242_();
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>(craftingSlotsSize);
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotIndex = buf.m_130242_();
            Slot slot = container.m_38853_(slotIndex);
            craftingSlots.add(slot);
        }
        int inventorySlotsSize = buf.m_130242_();
        ArrayList<Slot> inventorySlots = new ArrayList<Slot>();
        for (int i = 0; i < inventorySlotsSize; ++i) {
            int slotIndex = buf.m_130242_();
            Slot slot = container.m_38853_(slotIndex);
            inventorySlots.add(slot);
        }
        boolean maxTransfer = buf.readBoolean();
        boolean requireCompleteSets = buf.readBoolean();
        BasicRecipeTransferHandlerServer.setItems((Player)player, transferOperations, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets);
    }
}

