/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.debug;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.forge.config.ClientConfig;
import mezz.jei.plugins.debug.DebugFocusRecipeCategory;
import mezz.jei.plugins.debug.DebugGhostIngredientHandler;
import mezz.jei.plugins.debug.DebugRecipe;
import mezz.jei.plugins.debug.DebugRecipeCategory;
import mezz.jei.plugins.debug.FluidSubtypeHandlerTest;
import mezz.jei.plugins.debug.LegacyDebugRecipeCategory;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import mezz.jei.plugins.jei.ingredients.DebugIngredientHelper;
import mezz.jei.plugins.jei.ingredients.DebugIngredientListFactory;
import mezz.jei.plugins.jei.ingredients.DebugIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JeiDebugPlugin
implements IModPlugin {
    @Nullable
    public static IIngredientManager ingredientManager;
    @Nullable
    public static IJeiRuntime jeiRuntime;

    @Override
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "debug");
    }

    @Override
    public void registerIngredients(IModIngredientRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            DebugIngredientHelper ingredientHelper = new DebugIngredientHelper();
            DebugIngredientRenderer ingredientRenderer = new DebugIngredientRenderer(ingredientHelper);
            registration.register(DebugIngredient.TYPE, Collections.emptyList(), ingredientHelper, ingredientRenderer);
        }
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            IJeiHelpers jeiHelpers = registration.getJeiHelpers();
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            registration.addRecipeCategories(new DebugRecipeCategory(guiHelper), new DebugFocusRecipeCategory(guiHelper), new LegacyDebugRecipeCategory(guiHelper));
        }
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        ingredientManager = registration.getIngredientManager();
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            registration.addIngredientInfo(List.of(new ItemStack((ItemLike)Blocks.f_50154_), new ItemStack((ItemLike)Blocks.f_50484_), new ItemStack((ItemLike)Blocks.f_50485_), new ItemStack((ItemLike)Blocks.f_50486_), new ItemStack((ItemLike)Blocks.f_50487_), new ItemStack((ItemLike)Blocks.f_50488_)), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("description.jei.wooden.door.1"), new TranslatableComponent("description.jei.wooden.door.2"), new TranslatableComponent("description.jei.wooden.door.3")});
            registration.addIngredientInfo(new FluidStack((Fluid)Fluids.f_76193_, 1000), VanillaTypes.FLUID, new Component[]{new TextComponent("water")});
            registration.addIngredientInfo(new DebugIngredient(1), DebugIngredient.TYPE, new Component[]{new TextComponent("debug")});
            registration.addIngredientInfo(new DebugIngredient(2), DebugIngredient.TYPE, new Component[]{new TextComponent("debug colored").m_130940_(ChatFormatting.AQUA), new TextComponent("debug\\nSplit and colored").m_130940_(ChatFormatting.LIGHT_PURPLE), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{"various"}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{"various\\nsplit"}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{new TextComponent("various colored").m_130940_(ChatFormatting.RED)}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{new TextComponent("various\\nsplit colored").m_130940_(ChatFormatting.DARK_AQUA)}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{"\\nSplitting at the start"}), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{"various all colored"}).m_130940_(ChatFormatting.RED), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{new TranslatableComponent("description.jei.debug.formatting.3", new Object[]{"various"}).m_130940_(ChatFormatting.DARK_AQUA)}), new TranslatableComponent("description.jei.debug.formatting.2", new Object[]{new TextComponent("multiple").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.ITALIC), new TextComponent("various").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.BLUE), new TranslatableComponent("description.jei.debug.formatting.1", new Object[]{new TranslatableComponent("description.jei.debug.formatting.3", new Object[]{new TranslatableComponent("description.jei.debug.formatting.2", new Object[]{new TextComponent("multiple").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.ITALIC), new TextComponent("various").m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_AQUA)})})});
            registration.addRecipes(DebugRecipeCategory.TYPE, List.of(new DebugRecipe(), new DebugRecipe()));
            registration.addRecipes(DebugFocusRecipeCategory.TYPE, List.of(new DebugRecipe()));
            registration.addRecipes(List.of(new DebugRecipe(), new DebugRecipe()), LegacyDebugRecipeCategory.UID);
        }
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            registration.addGuiContainerHandler(BrewingStandScreen.class, new IGuiContainerHandler<BrewingStandScreen>(){

                @Override
                public List<Rect2i> getGuiExtraAreas(BrewingStandScreen containerScreen) {
                    int widthMovement = (int)(System.currentTimeMillis() / 100L % 100L);
                    int size = 25 + widthMovement;
                    return List.of(new Rect2i(containerScreen.getGuiLeft() + containerScreen.getXSize(), containerScreen.getGuiTop() + 40, size, size));
                }

                @Override
                @Nullable
                public Object getIngredientUnderMouse(BrewingStandScreen containerScreen, double mouseX, double mouseY) {
                    if (mouseX < 10.0 && mouseY < 10.0) {
                        return new FluidStack((Fluid)Fluids.f_76193_, 1000);
                    }
                    return null;
                }
            });
            registration.addGhostIngredientHandler(BrewingStandScreen.class, new DebugGhostIngredientHandler());
        }
    }

    @Override
    public void registerFluidSubtypes(ISubtypeRegistration registration) {
        FlowingFluid water = Fluids.f_76193_;
        FluidSubtypeHandlerTest subtype = new FluidSubtypeHandlerTest();
        registration.registerSubtypeInterpreter((Fluid)water, subtype);
    }

    @Override
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            registration.addRecipeCatalyst(DebugIngredient.TYPE, new DebugIngredient(7), DebugRecipeCategory.TYPE);
            registration.addRecipeCatalyst(VanillaTypes.FLUID, new FluidStack((Fluid)Fluids.f_76193_, 1000), DebugRecipeCategory.TYPE);
            registration.addRecipeCatalyst(VanillaTypes.ITEM, new ItemStack((ItemLike)Items.f_42398_), DebugRecipeCategory.TYPE);
            int i = 0;
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack catalystIngredient = new ItemStack((ItemLike)item);
                if (!catalystIngredient.m_41619_()) {
                    registration.addRecipeCatalyst(catalystIngredient, DebugRecipeCategory.TYPE);
                }
                if (++i <= 30) continue;
                break;
            }
        }
    }

    @Override
    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JeiDebugPlugin.jeiRuntime = jeiRuntime;
        if (ClientConfig.getInstance().isDebugModeEnabled()) {
            IIngredientManager ingredientManager = jeiRuntime.getIngredientManager();
            ingredientManager.addIngredientsAtRuntime(DebugIngredient.TYPE, DebugIngredientListFactory.create());
        }
    }
}

