/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials;

import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.core.ECSounds;
import corgitaco.enhancedcelestials.network.ForgeNetworkHandler;
import corgitaco.enhancedcelestials.util.ECRegistryObject;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="enhancedcelestials")
public class EnhancedCelestialsForge {
    public EnhancedCelestialsForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        EnhancedCelestialsForge.bootStrap(bus);
    }

    private static void bootStrap(IEventBus eventBus) {
        EnhancedCelestialsForge.register(SoundEvent.class, eventBus, () -> ECSounds.bootStrap());
    }

    private static <T extends IForgeRegistryEntry<T>> void register(Class clazz, IEventBus eventBus, Supplier<Collection<ECRegistryObject<T>>> registryObjectsSupplier) {
        eventBus.addGenericListener(clazz, event -> {
            Collection registryObjects = (Collection)registryObjectsSupplier.get();
            IForgeRegistry registry = event.getRegistry();
            for (ECRegistryObject registryObject : registryObjects) {
                ((IForgeRegistryEntry)registryObject.object()).setRegistryName(EnhancedCelestials.createLocation(registryObject.id()));
                registry.register((IForgeRegistryEntry)registryObject.object());
            }
            EnhancedCelestials.LOGGER.info("Enhanced Celestials registered: " + registry.getRegistryName());
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        EnhancedCelestials.commonSetup();
        ForgeNetworkHandler.init();
    }
}

