/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import java.util.Map;

public class LunarEventInstance {
    public static final Codec<LunarEventInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("lunarEventKey").forGetter(lunarEventInstance -> lunarEventInstance.lunarEventKey), (App)Codec.LONG.fieldOf("scheduledDay").forGetter(lunarEventInstance -> lunarEventInstance.scheduledDay)).apply((Applicative)builder, LunarEventInstance::new));
    private final String lunarEventKey;
    private long scheduledDay;

    public LunarEventInstance(String lunarEventKey, long scheduledDay) {
        this.lunarEventKey = lunarEventKey;
        this.scheduledDay = scheduledDay;
    }

    public String getLunarEventKey() {
        return this.lunarEventKey;
    }

    public LunarEvent getEvent(Map<String, LunarEvent> events) {
        return events.get(this.lunarEventKey);
    }

    public long scheduledDay() {
        return this.scheduledDay;
    }

    public long getDaysUntil(long currentDay) {
        return this.scheduledDay - currentDay;
    }

    public boolean passed(long currentDay) {
        return this.scheduledDay - currentDay <= -1L;
    }

    public boolean active(long currentDay) {
        return this.scheduledDay - currentDay == 0L;
    }

    public void setScheduledDay(int scheduledDay) {
        this.scheduledDay = scheduledDay;
    }
}

