/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.api.lunarevent.client.LunarEventClientSettings;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public class BlueMoon
extends LunarEvent {
    public static final Codec<BlueMoon> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LunarEventClientSettings.CODEC.fieldOf("clientSettings").forGetter(clientSettings -> clientSettings.getClientSettings()), (App)Codec.INT.fieldOf("minNumberOfNightsBetween").forGetter(clientSettings -> clientSettings.getMinNumberOfNightsBetween()), (App)Codec.DOUBLE.fieldOf("chance").forGetter(clientSettings -> clientSettings.getChance()), (App)Codec.list((Codec)Codec.INT).fieldOf("validMoonPhases").forGetter(clientSettings -> new ArrayList<Integer>(clientSettings.getValidMoonPhases())), (App)LunarTextComponents.CODEC.fieldOf("textComponents").forGetter(blueMoon -> blueMoon.getTextComponents()), (App)Codec.BOOL.fieldOf("blockSleeping").forGetter(clientSettings -> clientSettings.blockSleeping()), (App)Codec.INT.fieldOf("luckStrength").forGetter(blueMoon -> blueMoon.luckStrength + 1)).apply((Applicative)builder, BlueMoon::new));
    private final int luckStrength;

    public BlueMoon(LunarEventClientSettings clientSettings, int minNumberOfNightsBetween, double chance, Collection<Integer> validMoonPhases, LunarTextComponents lunarTextComponents, boolean blockSleeping, int luckStrength) {
        super(clientSettings, minNumberOfNightsBetween, chance, validMoonPhases, lunarTextComponents, blockSleeping);
        this.luckStrength = Mth.m_14045_((int)(luckStrength - 1), (int)0, (int)255);
    }

    @Override
    public void livingEntityTick(LivingEntity entity, Level world) {
        if (!world.f_46443_ && !(entity instanceof Monster)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 1210, this.luckStrength, true, false, false));
        }
    }

    @Override
    public Codec<? extends LunarEvent> codec() {
        return CODEC;
    }
}

