/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival;

import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.action.item.EntityItemAction;
import com.craftingdead.core.world.action.item.EntityItemActionType;
import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.clothing.Clothing;
import com.craftingdead.survival.ModDist;
import com.craftingdead.survival.ServerConfig;
import com.craftingdead.survival.client.ClientDist;
import com.craftingdead.survival.data.SurvivalItemTagsProvider;
import com.craftingdead.survival.data.SurvivalRecipeProvider;
import com.craftingdead.survival.data.loot.SurvivalLootTableProvider;
import com.craftingdead.survival.particles.SurvivalParticleTypes;
import com.craftingdead.survival.server.ServerDist;
import com.craftingdead.survival.world.action.SurvivalActionTypes;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import com.craftingdead.survival.world.entity.SurvivalEntityTypes;
import com.craftingdead.survival.world.entity.SurvivalPlayerHandler;
import com.craftingdead.survival.world.entity.SurvivalZombieHandler;
import com.craftingdead.survival.world.entity.monster.AdvancedZombie;
import com.craftingdead.survival.world.entity.monster.DoctorZombieEntity;
import com.craftingdead.survival.world.entity.monster.FastZombie;
import com.craftingdead.survival.world.entity.monster.GiantZombie;
import com.craftingdead.survival.world.entity.monster.PoliceZombieEntity;
import com.craftingdead.survival.world.entity.monster.TankZombie;
import com.craftingdead.survival.world.entity.monster.WeakZombie;
import com.craftingdead.survival.world.item.SurvivalItems;
import com.craftingdead.survival.world.item.enchantment.InfectionEnchantment;
import com.craftingdead.survival.world.item.enchantment.SurvivalEnchantments;
import com.craftingdead.survival.world.level.block.SurvivalBlocks;
import java.util.ListIterator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="craftingdeadsurvival")
public class CraftingDeadSurvival {
    public static final String ID = "craftingdeadsurvival";
    private static final String H_CD_SERVER_CORE_ID = "hcdservercore";
    public static final ServerConfig serverConfig;
    public static final ForgeConfigSpec serverConfigSpec;
    private static CraftingDeadSurvival instance;
    private final ModDist modDist;

    public CraftingDeadSurvival() {
        instance = this;
        this.modDist = (ModDist)DistExecutor.safeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleEntityAttributeCreation);
        modEventBus.addListener(this::handleGatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfigSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        SurvivalEnchantments.deferredRegister.register(modEventBus);
        SurvivalActionTypes.deferredRegister.register(modEventBus);
        SurvivalItems.deferredRegister.register(modEventBus);
        SurvivalMobEffects.deferredRegister.register(modEventBus);
        SurvivalEntityTypes.deferredRegister.register(modEventBus);
        SurvivalParticleTypes.deferredRegister.register(modEventBus);
        SurvivalBlocks.deferredRegister.register(modEventBus);
    }

    public ModDist getModDist() {
        return this.modDist;
    }

    public CraftingDeadSurvival getInstance() {
        return instance;
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SYRINGE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_, Items.f_42437_}), (ItemStack)new ItemStack((ItemLike)SurvivalItems.CURE_SYRINGE.get()));
        CraftingDeadSurvival.registerEntitySpawnPlacements();
    }

    private static void registerEntitySpawnPlacements() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)SurvivalEntityTypes.ADVANCED_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AdvancedZombie::checkAdvancedZombieSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)SurvivalEntityTypes.FAST_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AdvancedZombie::checkAdvancedZombieSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)SurvivalEntityTypes.TANK_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AdvancedZombie::checkAdvancedZombieSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)SurvivalEntityTypes.WEAK_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AdvancedZombie::checkAdvancedZombieSpawnRules);
    }

    private void handleEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)SurvivalEntityTypes.ADVANCED_ZOMBIE.get(), AdvancedZombie.createAttributes().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.DOCTOR_ZOMBIE.get(), DoctorZombieEntity.createAttributes().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.FAST_ZOMBIE.get(), FastZombie.createAttributes().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.GIANT_ZOMBIE.get(), GiantZombie.createAttributes().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.POLICE_ZOMBIE.get(), PoliceZombieEntity.createAttributes().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.TANK_ZOMBIE.get(), TankZombie.createAttributes().m_22265_());
        event.put((EntityType)SurvivalEntityTypes.WEAK_ZOMBIE.get(), WeakZombie.createAttributes().m_22265_());
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.m_123914_((DataProvider)new SurvivalItemTagsProvider(dataGenerator, (BlockTagsProvider)new ForgeBlockTagsProvider(dataGenerator, event.getExistingFileHelper()), event.getExistingFileHelper()));
            dataGenerator.m_123914_((DataProvider)new SurvivalRecipeProvider(dataGenerator));
            dataGenerator.m_123914_((DataProvider)new SurvivalLootTableProvider(dataGenerator));
        }
    }

    @SubscribeEvent
    public void handlePerformAction(LivingExtensionEvent.PerformAction<EntityItemAction<?>> event) {
        EntityItemAction action = (EntityItemAction)event.getAction();
        LivingExtension target = action.getSelectedTarget();
        if (!event.getLiving().getLevel().m_5776_() && action.getType() == ActionTypes.USE_SYRINGE.get()) {
            ((EntityItemActionType)SurvivalActionTypes.USE_SYRINGE_ON_ZOMBIE.get()).createEntityAction(event.getLiving(), target, action.getHand()).ifPresent(newAction -> {
                event.setCanceled(true);
                event.getLiving().performAction(newAction, true);
            });
        }
    }

    @SubscribeEvent
    public void handleMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        event.getMappings(H_CD_SERVER_CORE_ID).forEach(mapping -> {
            Block newBlock = (Block)mapping.registry.getValue(new ResourceLocation(ID, mapping.key.m_135815_()));
            if (newBlock != null) {
                mapping.remap((IForgeRegistryEntry)newBlock);
            }
        });
    }

    @SubscribeEvent
    public void handleMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        event.getMappings(H_CD_SERVER_CORE_ID).forEach(mapping -> {
            Item newItem = (Item)mapping.registry.getValue(new ResourceLocation(ID, mapping.key.m_135815_()));
            if (newItem != null) {
                mapping.remap((IForgeRegistryEntry)newItem);
            }
        });
    }

    @SubscribeEvent
    public void handleAttachLivingExtensions(LivingExtensionEvent.Load event) {
        LivingExtension livingExtension = event.getLiving();
        if (livingExtension instanceof PlayerExtension) {
            PlayerExtension player = (PlayerExtension)livingExtension;
            player.registerHandler(SurvivalPlayerHandler.TYPE, (LivingHandler)new SurvivalPlayerHandler(player));
        } else if (event.getLiving().getEntity() instanceof AdvancedZombie && (livingExtension = event.getLiving()) instanceof BasicLivingExtension) {
            BasicLivingExtension living = (BasicLivingExtension)livingExtension;
            living.registerHandler(SurvivalZombieHandler.TYPE, (LivingHandler)new SurvivalZombieHandler());
        }
    }

    @SubscribeEvent
    public void handleRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getWorld().m_5776_() && event.getItemStack().getCapability(Clothing.CAPABILITY).isPresent()) {
            PlayerExtension extension = PlayerExtension.getOrThrow((Player)event.getPlayer());
            extension.performAction((Action)((EntityItemActionType)SurvivalActionTypes.SHRED_CLOTHING.get()).decode((LivingExtension)extension, null), true);
        }
    }

    @SubscribeEvent
    public void handleGunHitEntity(GunEvent.HitEntity event) {
        event.getTarget().getCapability(LivingExtension.CAPABILITY).resolve().flatMap(living -> living.getHandler(SurvivalPlayerHandler.TYPE)).ifPresent(playerHandler -> {
            float enchantmentPct = (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)SurvivalEnchantments.INFECTION.get()), (ItemStack)event.getItemStack()) / (float)((InfectionEnchantment)((Object)((Object)SurvivalEnchantments.INFECTION.get()))).m_6586_();
            playerHandler.infect(enchantmentPct);
        });
    }

    @SubscribeEvent
    public void handleBiomeLoading(BiomeLoadingEvent event) {
        if (!((Boolean)CraftingDeadSurvival.serverConfig.zombiesEnabled.get()).booleanValue()) {
            return;
        }
        ListIterator<MobSpawnSettings.SpawnerData> iterator = event.getSpawns().getSpawner(MobCategory.MONSTER).listIterator();
        while (iterator.hasNext()) {
            MobSpawnSettings.SpawnerData spawnEntry = (MobSpawnSettings.SpawnerData)iterator.next();
            if (spawnEntry.f_48404_ != EntityType.f_20501_) continue;
            if (((Boolean)CraftingDeadSurvival.serverConfig.advancedZombiesEnabled.get()).booleanValue()) {
                iterator.add(new MobSpawnSettings.SpawnerData((EntityType)SurvivalEntityTypes.ADVANCED_ZOMBIE.get(), ((Integer)CraftingDeadSurvival.serverConfig.advancedZombieSpawnWeight.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.advancedZombieMinSpawn.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.advancedZombieMaxSpawn.get()).intValue()));
            }
            if (((Boolean)CraftingDeadSurvival.serverConfig.fastZombiesEnabled.get()).booleanValue()) {
                iterator.add(new MobSpawnSettings.SpawnerData((EntityType)SurvivalEntityTypes.FAST_ZOMBIE.get(), ((Integer)CraftingDeadSurvival.serverConfig.fastZombieSpawnWeight.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.fastZombieMinSpawn.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.fastZombieMaxSpawn.get()).intValue()));
            }
            if (((Boolean)CraftingDeadSurvival.serverConfig.tankZombiesEnabled.get()).booleanValue()) {
                iterator.add(new MobSpawnSettings.SpawnerData((EntityType)SurvivalEntityTypes.TANK_ZOMBIE.get(), ((Integer)CraftingDeadSurvival.serverConfig.tankZombieSpawnWeight.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.tankZombieMinSpawn.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.tankZombieMaxSpawn.get()).intValue()));
            }
            if (!((Boolean)CraftingDeadSurvival.serverConfig.weakZombiesEnabled.get()).booleanValue()) continue;
            iterator.add(new MobSpawnSettings.SpawnerData((EntityType)SurvivalEntityTypes.WEAK_ZOMBIE.get(), ((Integer)CraftingDeadSurvival.serverConfig.weakZombieSpawnWeight.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.weakZombieMinSpawn.get()).intValue(), ((Integer)CraftingDeadSurvival.serverConfig.weakZombieMaxSpawn.get()).intValue()));
        }
    }

    static {
        Pair serverConfigPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfigSpec = (ForgeConfigSpec)serverConfigPair.getRight();
        serverConfig = (ServerConfig)serverConfigPair.getLeft();
    }
}

