/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.data.loot;

import com.craftingdead.survival.data.loot.SupplyDropLootTables;
import com.craftingdead.survival.data.loot.SurvivalBlockLootTables;
import com.craftingdead.survival.world.level.storage.loot.BuiltInLootTables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class SurvivalLootTableProvider
extends LootTableProvider {
    public SurvivalLootTableProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Pair.of(SupplyDropLootTables::new, (Object)LootContextParamSets.f_81411_));
        builder.add((Object)Pair.of(SurvivalBlockLootTables::new, (Object)LootContextParamSets.f_81421_));
        return builder.build();
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
        for (ResourceLocation location2 : Sets.difference(BuiltInLootTables.getLootTables(), map.keySet())) {
            validationTracker.m_79357_("Missing built-in table: " + location2);
        }
        map.forEach((location, lootTable) -> LootTables.m_79202_((ValidationContext)validationTracker, (ResourceLocation)location, (LootTable)lootTable));
    }

    public String m_6055_() {
        return "Crafting Dead Loot Tables";
    }
}

