/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.action;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.action.TargetSelector;
import com.craftingdead.core.world.action.item.BlockItemActionType;
import com.craftingdead.core.world.action.item.EntityItemActionType;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.clothing.Clothing;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import com.craftingdead.survival.world.item.SurvivalItems;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class SurvivalActionTypes {
    public static final DeferredRegister<ActionType<?>> deferredRegister = DeferredRegister.create((ResourceKey)ActionTypes.REGISTRY_KEY, (String)"craftingdeadsurvival");
    public static final RegistryObject<EntityItemActionType<?>> SHRED_CLOTHING = deferredRegister.register("shred_clothing", () -> ((EntityItemActionType.Builder)EntityItemActionType.builder((TargetSelector)TargetSelector.SELF_ONLY).forItem(CapabilityUtil.capabilityPresent((Capability)Clothing.CAPABILITY))).customAction((performer, target) -> {
        Random random = target.getRandom();
        int randomRagAmount = random.nextInt(3) + 3;
        for (int i = 0; i < randomRagAmount; ++i) {
            if (random.nextBoolean()) {
                target.getEntity().m_19983_(new ItemStack(() -> SurvivalItems.CLEAN_RAG.get()));
                continue;
            }
            target.getEntity().m_19983_(new ItemStack(() -> SurvivalItems.DIRTY_RAG.get()));
        }
    }, 1.0f).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_SPLINT = deferredRegister.register("use_splint", () -> ((EntityItemActionType.Builder)EntityItemActionType.builder((TargetSelector)TargetSelector.SELF_OR_OTHERS.hasEffect(SurvivalMobEffects.BROKEN_LEG)).forItem(SurvivalItems.SPLINT)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_CLEAN_RAG = deferredRegister.register("use_clean_rag", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder((TargetSelector)TargetSelector.SELF_OR_OTHERS.hasEffect(SurvivalMobEffects.BLEEDING)).forItem(SurvivalItems.CLEAN_RAG)).duration(16)).returnItem(SurvivalItems.BLOODY_RAG)).build());
    public static final RegistryObject<BlockItemActionType> WASH_RAG = deferredRegister.register("wash_rag", () -> ((BlockItemActionType.Builder)((BlockItemActionType.Builder)((BlockItemActionType.Builder)((BlockItemActionType.Builder)BlockItemActionType.builder().forItem(itemStack -> itemStack.m_150930_((Item)SurvivalItems.DIRTY_RAG.get()) || itemStack.m_150930_((Item)SurvivalItems.BLOODY_RAG.get()))).returnItem(SurvivalItems.CLEAN_RAG)).consumeItemInCreative(true)).finishSound(SoundEvents.f_11781_)).forBlock(blockState -> blockState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_SYRINGE_ON_ZOMBIE = deferredRegister.register("use_syringe_on_zombie", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder((TargetSelector)TargetSelector.OTHERS_ONLY.ofEntityType(Zombie.class)).forItem((Supplier)ModItems.SYRINGE)).duration(16)).customAction((performer, target) -> ((Zombie)target.getEntity()).m_6469_(DamageSource.m_19370_((LivingEntity)target.getEntity()), 2.0f), 0.25f).returnItem(SurvivalItems.RBI_SYRINGE)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_CURE_SYRINGE = deferredRegister.register("use_cure_syringe", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder((TargetSelector)TargetSelector.SELF_OR_OTHERS).forItem(SurvivalItems.CURE_SYRINGE)).duration(16)).returnItem((Supplier)ModItems.SYRINGE)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_RBI_SYRINGE = deferredRegister.register("use_rbi_syringe", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder((TargetSelector)TargetSelector.SELF_OR_OTHERS).forItem(SurvivalItems.RBI_SYRINGE)).duration(16)).effect(() -> new MobEffectInstance((MobEffect)SurvivalMobEffects.INFECTION.get(), 9999999)).returnItem((Supplier)ModItems.SYRINGE)).build());
}

