/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity;

import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.world.effect.SurvivalMobEffects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;

public class SurvivalPlayerHandler
implements PlayerHandler {
    public static final LivingHandlerType<SurvivalPlayerHandler> TYPE = new LivingHandlerType(new ResourceLocation("craftingdeadsurvival", "survival_player"));
    private static final float ZOMBIE_INFECTION_CHANCE = 0.1f;
    private static final Random random = new Random();
    private final PlayerExtension<?> player;
    private int soundLevel;

    public SurvivalPlayerHandler(PlayerExtension<?> player) {
        this.player = player;
    }

    public PlayerExtension<?> getPlayer() {
        return this.player;
    }

    public int getSoundLevel() {
        return this.soundLevel;
    }

    public void addSoundLevel(int soundLevel) {
        this.soundLevel += soundLevel;
    }

    public void playerTick() {
        if (!this.player.getLevel().m_5776_()) {
            this.updateEffects();
            if (((Player)this.player.getEntity()).f_19797_ % 5 == 0 && this.soundLevel > 0) {
                --this.soundLevel;
            }
        }
    }

    private void updateEffects() {
        boolean invulnerable;
        boolean bl = invulnerable = ((Player)this.player.getEntity()).m_150110_().f_35934_ || this.player.getLevel().m_46791_() == Difficulty.PEACEFUL;
        if ((invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.bleedingEnabled.get()).booleanValue()) && ((Player)this.player.getEntity()).m_21023_((MobEffect)SurvivalMobEffects.BLEEDING.get())) {
            ((Player)this.player.getEntity()).m_21195_((MobEffect)SurvivalMobEffects.BLEEDING.get());
        }
        if ((invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.brokenLegsEnabled.get()).booleanValue()) && ((Player)this.player.getEntity()).m_21023_((MobEffect)SurvivalMobEffects.BROKEN_LEG.get())) {
            ((Player)this.player.getEntity()).m_21195_((MobEffect)SurvivalMobEffects.BROKEN_LEG.get());
        }
        if ((invulnerable || !((Boolean)CraftingDeadSurvival.serverConfig.infectionEnabled.get()).booleanValue()) && ((Player)this.player.getEntity()).m_21023_((MobEffect)SurvivalMobEffects.INFECTION.get())) {
            ((Player)this.player.getEntity()).m_21195_((MobEffect)SurvivalMobEffects.INFECTION.get());
        }
    }

    public boolean handleHurt(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Zombie) {
            this.infect(0.1f);
        }
        return false;
    }

    public void infect(float chance) {
        Player entity = (Player)this.player.getEntity();
        if (!entity.m_7500_() && entity.m_183503_().m_46791_() != Difficulty.PEACEFUL && entity.m_21187_().nextFloat() < chance && !entity.m_21023_((MobEffect)SurvivalMobEffects.INFECTION.get()) && ((Boolean)CraftingDeadSurvival.serverConfig.infectionEnabled.get()).booleanValue()) {
            entity.m_5661_((Component)new TranslatableComponent("message.infected").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
            entity.m_7292_(new MobEffectInstance((MobEffect)SurvivalMobEffects.INFECTION.get(), 9999999));
        }
    }

    public float handleDamaged(DamageSource source, float amount) {
        boolean invulnerable;
        boolean bl = invulnerable = ((Player)this.player.getEntity()).m_150110_().f_35934_ || this.player.getLevel().m_46791_() == Difficulty.PEACEFUL;
        if (!invulnerable && ((Boolean)CraftingDeadSurvival.serverConfig.bleedingEnabled.get()).booleanValue() && (source.m_7640_() != null || source.m_19372_())) {
            float bleedChance = 0.1f * amount;
            if (random.nextFloat() < bleedChance && !((Player)this.player.getEntity()).m_21023_((MobEffect)SurvivalMobEffects.BLEEDING.get())) {
                ((Player)this.player.getEntity()).m_5661_((Component)new TranslatableComponent("message.bleeding").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                ((Player)this.player.getEntity()).m_7292_(new MobEffectInstance((MobEffect)SurvivalMobEffects.BLEEDING.get(), 9999999));
            }
        }
        if (!invulnerable && ((Boolean)CraftingDeadSurvival.serverConfig.brokenLegsEnabled.get()).booleanValue() && !((Player)this.player.getEntity()).m_21023_((MobEffect)SurvivalMobEffects.BROKEN_LEG.get()) && source == DamageSource.f_19315_ && (amount > 0.0f && random.nextInt(3) == 0 || amount > 4.0f)) {
            ((Player)this.player.getEntity()).m_5661_((Component)new TranslatableComponent("message.broken_leg").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
            ((Player)this.player.getEntity()).m_7292_(new MobEffectInstance((MobEffect)SurvivalMobEffects.BROKEN_LEG.get(), 9999999, 4));
            ((Player)this.player.getEntity()).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1));
        }
        return amount;
    }

    public void encode(FriendlyByteBuf out, boolean writeAll) {
    }

    public void decode(FriendlyByteBuf in) {
    }

    public boolean requiresSync() {
        return false;
    }
}

