/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.survival.world.entity.monster;

import com.craftingdead.core.world.entity.ai.FollowAttractiveGrenadeGoal;
import com.craftingdead.core.world.entity.ai.LookAtEntityGoal;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.grenade.FlashGrenadeEntity;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.survival.CraftingDeadSurvival;
import com.craftingdead.survival.tags.SurvivalItemTags;
import com.craftingdead.survival.world.entity.SurvivalPlayerHandler;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class AdvancedZombie
extends Zombie
implements RangedAttackMob {
    private static final UUID DAMAGE_MODIFIER_BABY_UUID = UUID.fromString("53405062-b8d8-461c-a542-26b0be8ed481");
    private static final AttributeModifier DAMAGE_MODIFIER_BABY = new AttributeModifier(DAMAGE_MODIFIER_BABY_UUID, "Baby damage reduction", -1.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final UUID HEALTH_MODIFIER_BABY_UUID = UUID.fromString("69d754ea-1ae3-4684-bb69-51a29de92b9a");
    private static final AttributeModifier HEALTH_MODIFIER_BABY = new AttributeModifier(HEALTH_MODIFIER_BABY_UUID, "Baby health reduction", -1.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Integer> TEXTURE_NUMBER = SynchedEntityData.m_135353_(AdvancedZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private RangedAttackGoal rangedAttackGoal;
    private long triggerPressedStartTime;

    public AdvancedZombie(EntityType<? extends AdvancedZombie> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.rangedAttackGoal = new RangedAttackGoal(this, 1.0, 40, 20.0f){

            public boolean m_8036_() {
                return super.m_8036_() && AdvancedZombie.this.m_21205_().getCapability(Gun.CAPABILITY).isPresent();
            }
        };
        this.f_21345_.m_25352_(2, (Goal)this.rangedAttackGoal);
        this.f_21345_.m_25352_(1, (Goal)new FollowAttractiveGrenadeGoal((Mob)this, (double)1.15f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtEntityGoal((Mob)this, FlashGrenadeEntity.class, 20.0f, 0.35f));
    }

    protected void m_6878_() {
        super.m_6878_();
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, 5, false, false, targetEntity -> targetEntity.getCapability(LivingExtension.CAPABILITY).resolve().flatMap(extension -> extension.getHandler(SurvivalPlayerHandler.TYPE)).map(handler -> (float)handler.getSoundLevel() >= targetEntity.m_20270_((Entity)this)).orElse(false)){

            public double m_7623_() {
                return 100.0;
            }
        });
    }

    public void m_6863_(boolean baby) {
        if (!((Boolean)CraftingDeadSurvival.serverConfig.babyZombiesEnabled.get()).booleanValue()) {
            return;
        }
        super.m_6863_(baby);
        if (!this.f_19853_.f_46443_) {
            AttributeInstance damageAttribute = this.m_21051_(Attributes.f_22281_);
            damageAttribute.m_22130_(DAMAGE_MODIFIER_BABY);
            damageAttribute.m_22130_(HEALTH_MODIFIER_BABY);
            if (baby) {
                damageAttribute.m_22118_(DAMAGE_MODIFIER_BABY);
                damageAttribute.m_22118_(HEALTH_MODIFIER_BABY);
            }
        }
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TEXTURE_NUMBER, (Object)0);
    }

    public int m_21230_() {
        int armorValue = super.m_21230_() + 2;
        if (armorValue > 20) {
            armorValue = 20;
        }
        return armorValue;
    }

    public int m_5792_() {
        return 12;
    }

    protected boolean m_5884_() {
        return false;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(TEXTURE_NUMBER, (Object)compound.m_128451_("textureNumber"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("textureNumber", ((Integer)this.f_19804_.m_135370_(TEXTURE_NUMBER)).intValue());
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        this.f_19804_.m_135381_(TEXTURE_NUMBER, (Object)this.f_19796_.nextInt(23));
        this.m_8061_(EquipmentSlot.MAINHAND, this.createHeldItem());
        this.getCapability(LivingExtension.CAPABILITY).ifPresent(living -> {
            living.getItemHandler().setStackInSlot(ModEquipmentSlot.CLOTHING.getIndex(), this.createClothingItem());
            living.getItemHandler().setStackInSlot(ModEquipmentSlot.HAT.getIndex(), this.getHatStack());
        });
    }

    protected ItemStack createHeldItem() {
        return this.getRandomItem(SurvivalItemTags.ZOMBIE_HAND_LOOT, ((Double)CraftingDeadSurvival.serverConfig.zombieHandSpawnChance.get()).floatValue()).map(Item::m_7968_).orElse(ItemStack.f_41583_);
    }

    protected ItemStack createClothingItem() {
        return this.getRandomItem(SurvivalItemTags.ZOMBIE_CLOTHING_LOOT, ((Double)CraftingDeadSurvival.serverConfig.zombieClothingSpawnChance.get()).floatValue()).map(Item::m_7968_).orElse(ItemStack.f_41583_);
    }

    protected ItemStack getHatStack() {
        return this.getRandomItem(SurvivalItemTags.ZOMBIE_HAT_LOOT, ((Double)CraftingDeadSurvival.serverConfig.zombieHatSpawnChance.get()).floatValue()).map(Item::m_7968_).orElse(ItemStack.f_41583_);
    }

    protected Optional<Item> getRandomItem(TagKey<Item> tagKey, float probability) {
        return this.f_19796_.nextFloat() < probability ? Registry.f_122827_.m_203431_(tagKey).flatMap(tag -> tag.m_203450_(this.f_19796_)).map(Holder::m_203334_) : Optional.empty();
    }

    public int getTextureNumber() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_NUMBER);
    }

    public static boolean checkAdvancedZombieSpawnRules(EntityType<? extends AdvancedZombie> entityType, LevelAccessor level, MobSpawnType reason, BlockPos blockPos, Random random) {
        return level.m_45517_(LightLayer.BLOCK, blockPos) <= 8 && AdvancedZombie.m_33023_(entityType, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)blockPos, (Random)random);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            this.getCapability(LivingExtension.CAPABILITY).ifPresent(living -> living.getMainHandGun().ifPresent(gun -> {
                if (gun.isTriggerPressed() && (!this.rangedAttackGoal.m_8045_() || Util.m_137550_() - this.triggerPressedStartTime > (long)(1000 + this.f_19796_.nextInt(2000)))) {
                    gun.setTriggerPressed(living, false, true);
                }
            }));
        }
    }

    public void m_6504_(LivingEntity livingEntity, float distance) {
        if (!this.f_19853_.m_5776_()) {
            this.getCapability(LivingExtension.CAPABILITY).ifPresent(living -> living.getMainHandGun().ifPresent(gun -> {
                this.triggerPressedStartTime = Util.m_137550_();
                gun.setTriggerPressed(living, true, true);
            }));
        }
    }

    public static AttributeSupplier.Builder attributeTemplate() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22282_, 0.0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AdvancedZombie.attributeTemplate().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_6668_(DamageSource damageSource) {
        if (((Boolean)CraftingDeadSurvival.serverConfig.zombieDeathLootEnabled.get()).booleanValue()) {
            super.m_6668_(damageSource);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        groupData = super.m_6518_(level, difficulty, spawnType, groupData, tag);
        if (!level.m_5776_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22282_)).m_22100_(((Double)CraftingDeadSurvival.serverConfig.zombieAttackKnockback.get()).doubleValue());
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(((Double)CraftingDeadSurvival.serverConfig.advancedZombieMaxHealth.get()).doubleValue());
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(((Double)CraftingDeadSurvival.serverConfig.advancedZombieAttackDamage.get()).doubleValue());
        }
        LivingExtension extension = LivingExtension.getOrThrow((LivingEntity)this);
        extension.setEquipmentDropChance(ModEquipmentSlot.CLOTHING, ((Double)CraftingDeadSurvival.serverConfig.zombieClothingDropChance.get()).floatValue());
        extension.setEquipmentDropChance(ModEquipmentSlot.HAT, ((Double)CraftingDeadSurvival.serverConfig.zombieHatDropChance.get()).floatValue());
        Arrays.fill(this.f_21347_, ((Double)CraftingDeadSurvival.serverConfig.zombieHandDropChance.get()).floatValue());
        return groupData;
    }
}

