/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core;

import com.craftingdead.core.ModDist;
import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.client.animation.gun.GunAnimationTypes;
import com.craftingdead.core.data.recipes.ModRecipeProvider;
import com.craftingdead.core.data.tags.ModItemTagsProvider;
import com.craftingdead.core.event.CombatPickupEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.SyncLivingMessage;
import com.craftingdead.core.particle.ModParticleTypes;
import com.craftingdead.core.server.ServerDist;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.extension.BasicLivingExtension;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.inventory.ModMenuTypes;
import com.craftingdead.core.world.inventory.storage.Storage;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.clothing.Clothing;
import com.craftingdead.core.world.item.combatslot.CombatSlot;
import com.craftingdead.core.world.item.combatslot.CombatSlotProvider;
import com.craftingdead.core.world.item.crafting.ModRecipeSerializers;
import com.craftingdead.core.world.item.enchantment.ModEnchantments;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunTriggerPredicates;
import com.craftingdead.core.world.item.gun.GunTypeFactories;
import com.craftingdead.core.world.item.gun.GunTypes;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderTypes;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import com.craftingdead.core.world.item.gun.skin.Paint;
import com.craftingdead.core.world.item.hat.Hat;
import com.craftingdead.core.world.item.scope.Scope;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.JarVersionLookupHandler;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Mod(value="craftingdead")
public class CraftingDead {
    public static final String ID = "craftingdead";
    public static final String VERSION = JarVersionLookupHandler.getImplementationVersion(CraftingDead.class).orElse("[version]");
    private static final Logger logger = LogUtils.getLogger();
    public static final ServerConfig serverConfig;
    public static final ForgeConfigSpec serverConfigSpec;
    private static CraftingDead instance;
    private final ModDist modDist;

    public CraftingDead() {
        instance = this;
        this.modDist = (ModDist)DistExecutor.unsafeRunForDist(() -> ClientDist::new, () -> ServerDist::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::handleCommonSetup);
        modEventBus.addListener(this::handleGatherData);
        modEventBus.addListener(this::handleRegisterCapabilities);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfigSpec);
        ModEntityTypes.deferredRegister.register(modEventBus);
        ModItems.deferredRegister.register(modEventBus);
        ModSoundEvents.deferredRegister.register(modEventBus);
        ModMenuTypes.deferredRegister.register(modEventBus);
        ModMobEffects.deferredRegister.register(modEventBus);
        ModEnchantments.deferredRegister.register(modEventBus);
        ModParticleTypes.deferredRegister.register(modEventBus);
        ModRecipeSerializers.deferredRegister.register(modEventBus);
        ActionTypes.deferredRegister.register(modEventBus);
        AmmoProviderTypes.deferredRegister.register(modEventBus);
        Attachments.deferredRegister.register(modEventBus);
        GunTypes.deferredRegister.register(modEventBus);
        GunTypeFactories.deferredRegister.register(modEventBus);
        GunAnimationTypes.deferredRegister.register(modEventBus);
        GunTriggerPredicates.deferredRegister.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ModDist getModDist() {
        return this.modDist;
    }

    public ClientDist getClientDist() {
        ModDist modDist = this.modDist;
        if (modDist instanceof ClientDist) {
            ClientDist clientDist = (ClientDist)modDist;
            return clientDist;
        }
        throw new IllegalStateException("Accessing client dist on wrong side");
    }

    public static CraftingDead getInstance() {
        return instance;
    }

    private void handleCommonSetup(FMLCommonSetupEvent event) {
        logger.info("Starting Crafting Dead, version {}", (Object)VERSION);
        NetworkChannel.loadChannels();
        event.enqueueWork(() -> BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SYRINGE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), (ItemStack)new ItemStack((ItemLike)ModItems.ADRENALINE_SYRINGE.get())));
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        if (event.includeServer()) {
            dataGenerator.m_123914_((DataProvider)new ModItemTagsProvider(dataGenerator, (BlockTagsProvider)new ForgeBlockTagsProvider(dataGenerator, event.getExistingFileHelper()), event.getExistingFileHelper()));
            dataGenerator.m_123914_((DataProvider)new ModRecipeProvider(dataGenerator));
        }
    }

    private void handleRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(LivingExtension.class);
        event.register(Storage.class);
        event.register(Clothing.class);
        event.register(Hat.class);
        event.register(CombatSlotProvider.class);
        event.register(Gun.class);
        event.register(Magazine.class);
        event.register(Scope.class);
        event.register(Paint.class);
    }

    @SubscribeEvent
    public void handleAttack(AttackEntityEvent event) {
        event.setCanceled(PlayerExtension.getOrThrow(event.getPlayer()).handleAttack(event.getTarget()));
    }

    @SubscribeEvent
    public void handleInteract(PlayerInteractEvent.EntityInteract event) {
        event.setCanceled(PlayerExtension.getOrThrow(event.getPlayer()).handleInteract(event.getHand(), event.getTarget()));
    }

    @SubscribeEvent
    public void handlePlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        event.setCanceled(PlayerExtension.getOrThrow(event.getPlayer()).handleLeftClickBlock(event.getPos(), event.getFace(), arg_0 -> ((PlayerInteractEvent.LeftClickBlock)event).setUseBlock(arg_0), arg_0 -> ((PlayerInteractEvent.LeftClickBlock)event).setUseItem(arg_0)));
    }

    @SubscribeEvent
    public void handlePlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        event.setCanceled(PlayerExtension.getOrThrow(event.getPlayer()).handleRightClickBlock(event.getHand(), event.getPos(), event.getFace()));
    }

    @SubscribeEvent
    public void handlePlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        event.setCanceled(PlayerExtension.getOrThrow(event.getPlayer()).handleRightClickItem(event.getHand()));
    }

    @SubscribeEvent
    public void handleEntityItemPickup(EntityItemPickupEvent event) {
        event.getPlayer().getCapability(LivingExtension.CAPABILITY).cast().filter(PlayerExtension::isCombatModeEnabled).ifPresent(living -> {
            CombatSlot combatSlot;
            ItemStack itemStack = event.getItem().m_32055_();
            CombatPickupEvent combatPickupEvent = new CombatPickupEvent(itemStack, combatSlot = (CombatSlot)CombatSlot.getSlotType(itemStack).orElse(null));
            if (MinecraftForge.EVENT_BUS.post((Event)combatPickupEvent)) {
                event.setCanceled(true);
            } else if (combatSlot != null) {
                if (combatSlot.addToInventory(itemStack, event.getPlayer().m_150109_(), false)) {
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingSetTarget(LivingSetAttackTargetEvent event) {
        Mob mob;
        LivingEntity livingEntity;
        if (event.getTarget() != null && (livingEntity = event.getEntityLiving()) instanceof Mob && (mob = (Mob)livingEntity).m_21023_((MobEffect)ModMobEffects.FLASH_BLINDNESS.get())) {
            mob.m_6710_(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDeath(LivingDeathEvent event) {
        if (event.getEntity().getCapability(LivingExtension.CAPABILITY).map(living -> living.handleDeath(event.getSource())).orElse(false).booleanValue() || event.getSource().m_7639_() != null && event.getSource().m_7639_().getCapability(LivingExtension.CAPABILITY).map(living -> living.handleKill(event.getEntity())).orElse(false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDrops(LivingDropsEvent event) {
        event.getEntity().getCapability(LivingExtension.CAPABILITY).ifPresent(living -> event.setCanceled(living.handleDeathLoot(event.getSource(), event.getDrops(), event.getLootingLevel())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingAttack(LivingAttackEvent event) {
        event.getEntity().getCapability(LivingExtension.CAPABILITY).ifPresent(living -> event.setCanceled(living.handleHurt(event.getSource(), event.getAmount())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleLivingDamage(LivingDamageEvent event) {
        event.getEntity().getCapability(LivingExtension.CAPABILITY).ifPresent(living -> event.setAmount(living.handleDamaged(event.getSource(), event.getAmount())));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleEntityBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() != null) {
            event.getEntity().getCapability(LivingExtension.CAPABILITY).ifPresent(living -> event.setCanceled(living.handleBlockPlace(event.getBlockSnapshot(), event.getPlacedBlock(), event.getPlacedAgainst())));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleEntityBlockMultiPlace(BlockEvent.EntityMultiPlaceEvent event) {
        if (event.getEntity() != null) {
            event.getEntity().getCapability(LivingExtension.CAPABILITY).ifPresent(living -> event.setCanceled(living.handleMultiBlockPlace(event.getReplacedBlockSnapshots(), event.getPlacedBlock(), event.getPlacedAgainst())));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleEntityBlockBreakEvent(BlockEvent.BreakEvent event) {
        MutableInt xp = new MutableInt(event.getExpToDrop());
        event.setCanceled(PlayerExtension.getOrThrow(event.getPlayer()).handleBlockBreak(event.getPos(), event.getState(), xp));
        event.setExpToDrop(xp.getValue().intValue());
    }

    @SubscribeEvent
    public void handlePlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        PlayerExtension.getOrThrow(event.getPlayer()).copyFrom(PlayerExtension.getOrThrow((ServerPlayer)event.getOriginal()), event.isWasDeath());
    }

    @SubscribeEvent
    public void handleLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        event.getEntityLiving().getCapability(LivingExtension.CAPABILITY).ifPresent(living -> {
            living.tick();
            if (!living.getLevel().m_5776_() && living.requiresSync()) {
                FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
                living.encode(data, false);
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(living::getEntity), (Object)new SyncLivingMessage(living.getEntity().m_142049_(), data));
            }
        });
    }

    @SubscribeEvent
    public void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        switch (event.phase) {
            case END: {
                event.player.getCapability(LivingExtension.CAPABILITY).map(PlayerExtension.class::cast).ifPresent(PlayerHandler::playerTick);
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LivingEntity) {
            LivingExtension<LivingEntity, LivingHandler> livingExtension;
            LivingEntity entity = (LivingEntity)object;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                livingExtension = PlayerExtension.create(player);
            } else {
                livingExtension = BasicLivingExtension.create(entity);
            }
            BasicLivingExtension living = livingExtension;
            event.addCapability(LivingExtension.CAPABILITY_KEY, CapabilityUtil.serializableProvider(() -> living, LivingExtension.CAPABILITY));
            living.load();
        }
    }

    @SubscribeEvent
    public void handlePlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        PlayerExtension.getOrThrow(event.getPlayer()).encode(data, true);
        NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((PlayerEvent.PlayerChangedDimensionEvent)event).getPlayer()), (Object)new SyncLivingMessage(event.getPlayer().m_142049_(), data));
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CraftingDead.startTracking((Entity)event.getPlayer(), (ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public void handlePlayerStartTracking(PlayerEvent.StartTracking event) {
        CraftingDead.startTracking(event.getTarget(), (ServerPlayer)event.getPlayer());
    }

    private static void startTracking(Entity targetEntity, ServerPlayer playerEntity) {
        targetEntity.getCapability(LivingExtension.CAPABILITY).ifPresent(trackedLiving -> {
            trackedLiving.handleStartTracking(playerEntity);
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            trackedLiving.encode(data, true);
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> playerEntity), (Object)new SyncLivingMessage(trackedLiving.getEntity().m_142049_(), data));
        });
    }

    static {
        Pair serverConfigPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfigSpec = (ForgeConfigSpec)serverConfigPair.getRight();
        serverConfig = (ServerConfig)serverConfigPair.getLeft();
    }
}

