/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.animation;

import com.craftingdead.core.client.animation.Animation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class AnimationController {
    private final Queue<Animation> animations = new ArrayDeque<Animation>();

    public void addAnimation(Animation animation) {
        this.animations.add(animation);
    }

    public void tick() {
        Iterator iterator = this.animations.iterator();
        while (iterator.hasNext()) {
            Animation animation = (Animation)iterator.next();
            animation.tick();
            if (animation.isAlive()) continue;
            iterator.remove();
        }
    }

    public void apply(float partialTicks, PoseStack poseStack) {
        for (Animation animation : this.animations) {
            if (!animation.isAlive()) continue;
            animation.apply(partialTicks, poseStack);
        }
    }

    public void applyArm(InteractionHand hand, HumanoidArm arm, float partialTicks, PoseStack poseStack) {
        for (Animation animation : this.animations) {
            if (!animation.isAlive()) continue;
            animation.applyArm(hand, arm, partialTicks, poseStack);
        }
    }

    public void applyCamera(float partialTicks, Vector3f rotations) {
        for (Animation animation : this.animations) {
            if (!animation.isAlive()) continue;
            animation.applyCamera(partialTicks, rotations);
        }
    }
}

