/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.crosshair;

import com.craftingdead.core.client.crosshair.Crosshair;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class CrosshairManager
extends SimplePreparableReloadListener<Map<ResourceLocation, Crosshair>> {
    public static final ResourceLocation DEFAULT_CROSSHAIR = new ResourceLocation("craftingdead", "standard");
    private static final Gson gson = new Gson();
    private static final Logger logger = LogUtils.getLogger();
    private final Map<ResourceLocation, Crosshair> loadedCrosshairs = new HashMap<ResourceLocation, Crosshair>();

    public Crosshair getCrosshair(ResourceLocation crosshairLocation) {
        Crosshair crosshair = this.loadedCrosshairs.get(crosshairLocation);
        return crosshair != null ? crosshair : this.loadedCrosshairs.get(DEFAULT_CROSSHAIR);
    }

    protected Map<ResourceLocation, Crosshair> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder crosshairs = ImmutableMap.builder();
        for (String domain : resourceManager.m_7187_()) {
            ResourceLocation fileLocation = new ResourceLocation(domain, "crosshairs.json");
            try {
                resourceManager.m_7396_(fileLocation).forEach(resource -> {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_6679_());){
                        ((List)Codec.list(Crosshair.CODEC).parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)gson.fromJson((Reader)reader, JsonElement.class))).getOrThrow(false, message -> logger.warn("Failed to parse {} Reason: ", (Object)fileLocation.toString(), message))).forEach(crosshair -> crosshairs.put((Object)crosshair.getName(), crosshair));
                    }
                    catch (IOException e) {
                        logger.warn("Failed to read {}", (Object)fileLocation.toString(), (Object)e);
                    }
                });
            }
            catch (IOException iOException) {}
        }
        return crosshairs.build();
    }

    protected void apply(Map<ResourceLocation, Crosshair> crosshairs, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.loadedCrosshairs.clear();
        this.loadedCrosshairs.putAll(crosshairs);
    }
}

