/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.gui;

import com.craftingdead.core.client.util.RenderUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class HitMarker {
    private static final int HIT_MARKER_FADE_TIME_MS = 200;
    private static final int HIT_MARKER_SIZE = 12;
    private final Vec3 pos;
    private final Type type;
    private long fadeStartTimeMs;

    private HitMarker(Vec3 pos, Type type) {
        this.pos = pos;
        this.type = type;
    }

    public boolean render(PoseStack poseStack, int width, int height, float partialTicks) {
        if (this.fadeStartTimeMs == 0L) {
            this.fadeStartTimeMs = Util.m_137550_();
        }
        float zeroToOneFadePct = Mth.m_14036_((float)((float)(Util.m_137550_() - this.fadeStartTimeMs) / 200.0f), (float)0.0f, (float)1.0f);
        float oneToZeroFadePct = 1.0f - zeroToOneFadePct;
        if (zeroToOneFadePct == 1.0f) {
            return true;
        }
        Vec2 pos = RenderUtil.projectToPlayerView(this.pos.m_7096_(), this.pos.m_7098_(), this.pos.m_7094_(), partialTicks);
        if (pos == null) {
            return false;
        }
        float alpha = (float)(this.type.colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.type.colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.type.colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.type.colour & 0xFF) / 255.0f;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)(alpha * oneToZeroFadePct));
        RenderSystem.m_157427_(GameRenderer::m_172757_);
        poseStack.m_85836_();
        float leastCrossEndPos = 12.0f * oneToZeroFadePct;
        float higherCrossEndPos = leastCrossEndPos * 2.0f;
        float markerSizeMean = (higherCrossEndPos + leastCrossEndPos) / 2.0f;
        poseStack.m_85837_((double)((float)(width / 2) + pos.f_82470_ - markerSizeMean), (double)((float)(height / 2) - pos.f_82471_ - markerSizeMean), 0.0);
        RenderSystem.m_69832_((float)(oneToZeroFadePct * 4.5f));
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        builder.m_85982_(matrix, higherCrossEndPos, leastCrossEndPos, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, leastCrossEndPos, higherCrossEndPos, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        builder.m_85982_(matrix, leastCrossEndPos, leastCrossEndPos, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, higherCrossEndPos, higherCrossEndPos, 0.0f).m_6122_(255, 255, 255, 255).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        return false;
    }

    public static enum Type {
        HIT(-1),
        KILL(-5043200);

        private final int colour;

        private Type(int colour) {
            this.colour = colour;
        }
    }

    public static enum Mode {
        OFF((pos, kill) -> Optional.empty()),
        KILL((pos, kill) -> kill != false ? Optional.of(new HitMarker((Vec3)pos, Type.KILL)) : Optional.empty()),
        HIT_AND_KILL((pos, kill) -> Optional.of(new HitMarker((Vec3)pos, kill != false ? Type.KILL : Type.HIT)));

        private final BiFunction<Vec3, Boolean, Optional<HitMarker>> factory;

        private Mode(BiFunction<Vec3, Boolean, Optional<HitMarker>> factory) {
            this.factory = factory;
        }

        public Optional<HitMarker> createHitMarker(Vec3 pos, boolean kill) {
            return this.factory.apply(pos, kill);
        }
    }
}

