/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.gui.screen.inventory;

import com.craftingdead.core.client.gui.widget.button.CompositeButton;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.OpenStorageMessage;
import com.craftingdead.core.world.inventory.EquipmentMenu;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.inventory.storage.Storage;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.skin.Paint;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EquipmentScreen
extends EffectRenderingInventoryScreen<EquipmentMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("craftingdead", "textures/gui/container/equipment.png");
    private int oldMouseX;
    private int oldMouseY;
    private Button backpackButton;
    private Button vestButton;
    private boolean transitioning = false;

    public EquipmentScreen(EquipmentMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    public void m_7856_() {
        super.m_7856_();
        this.vestButton = CompositeButton.button(this.f_97735_ + 95, this.f_97736_ + 44, 12, 16, BACKGROUND).setAtlasPos(196, 224).setHoverAtlasPos(196, 240).setInactiveAtlasPos(183, 240).setAction(button -> {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenStorageMessage(ModEquipmentSlot.VEST));
            this.transitioning = true;
        }).build();
        this.m_142416_((GuiEventListener)this.vestButton);
        this.backpackButton = CompositeButton.button(this.f_97735_ + 95, this.f_97736_ + 62, 12, 16, BACKGROUND).setAtlasPos(196, 224).setHoverAtlasPos(196, 240).setInactiveAtlasPos(183, 240).setAction(button -> {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenStorageMessage(ModEquipmentSlot.BACKPACK));
            this.transitioning = true;
        }).build();
        this.m_142416_((GuiEventListener)this.backpackButton);
        this.refreshButtonStatus();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.refreshButtonStatus();
    }

    private void refreshButtonStatus() {
        this.backpackButton.f_93623_ = ((EquipmentMenu)this.f_97732_).getItemHandler().getStackInSlot(ModEquipmentSlot.BACKPACK.getIndex()).getCapability(Storage.CAPABILITY).isPresent();
        this.vestButton.f_93623_ = ((EquipmentMenu)this.f_97732_).getItemHandler().getStackInSlot(ModEquipmentSlot.VEST.getIndex()).getCapability(Storage.CAPABILITY).isPresent();
    }

    public boolean isTransitioning() {
        return this.transitioning;
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 35; i < ((EquipmentMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((EquipmentMenu)this.f_97732_).f_38839_.get(i);
            if (!slot.m_6657_()) continue;
            this.m_93228_(poseStack, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, 8, 141, 16, 16);
        }
        ItemStack gunStack = ((EquipmentMenu)this.f_97732_).getGunStack();
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            boolean carriedItemAccepted;
            int gunSlotX = this.f_97735_ + 135;
            int gunSlotY = this.f_97736_ + 26;
            boolean bl = carriedItemAccepted = gun.isAcceptedAttachment(((EquipmentMenu)this.f_97732_).m_142621_()) || Paint.isValid(((EquipmentMenu)this.f_97732_).getGunStack(), ((EquipmentMenu)this.f_97732_).m_142621_());
            if (!((EquipmentMenu)this.f_97732_).isCraftingInventoryEmpty() && ((EquipmentMenu)this.f_97732_).isCraftable() || !((EquipmentMenu)this.f_97732_).m_142621_().m_41619_() && carriedItemAccepted) {
                this.m_93228_(poseStack, gunSlotX, gunSlotY, 165, 238, 16, 16);
            } else if (!((EquipmentMenu)this.f_97732_).m_142621_().m_41619_() && !carriedItemAccepted) {
                this.m_93228_(poseStack, gunSlotX, gunSlotY, 147, 238, 16, 16);
            }
        });
        InventoryScreen.m_98850_((int)(this.f_97735_ + 51), (int)(this.f_97736_ + 72), (int)30, (float)(this.f_97735_ + 51 - this.oldMouseX), (float)(this.f_97736_ + 75 - 50 - this.oldMouseY), (LivingEntity)this.f_96541_.f_91074_);
    }
}

