/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class CompositeButton
extends Button {
    private final ResourceLocation textureLocation;
    private final int atlasX;
    private final int atlasY;
    private final int atlasXHover;
    private final int atlasYHover;
    private final int atlasXInactive;
    private final int atlasYInactive;

    private CompositeButton(Builder builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.text, builder.action);
        this.textureLocation = builder.textureLocation;
        this.atlasX = builder.atlasX;
        this.atlasY = builder.atlasY;
        this.atlasXHover = builder.atlasXHover;
        this.atlasYHover = builder.atlasYHover;
        this.atlasXInactive = builder.atlasXInactive;
        this.atlasYInactive = builder.atlasYInactive;
    }

    public static Builder button(int x, int y, int width, int height, ResourceLocation textureLocation) {
        return new Builder(x, y, width, height, textureLocation, CompositeButton::new);
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureLocation);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        if (this.m_142518_()) {
            if (this.m_198029_()) {
                this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, this.atlasXHover, this.atlasYHover, this.f_93618_, this.f_93619_);
            } else {
                this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, this.atlasX, this.atlasY, this.f_93618_, this.f_93619_);
            }
        } else {
            this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, this.atlasXInactive, this.atlasYInactive, this.f_93618_, this.f_93619_);
        }
    }

    public static class Builder {
        private final Function<Builder, CompositeButton> factory;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final ResourceLocation textureLocation;
        private int atlasX;
        private int atlasY;
        private int atlasXHover;
        private int atlasYHover;
        private int atlasXInactive;
        private int atlasYInactive;
        private Button.OnPress action = button -> {};
        private Component text = TextComponent.f_131282_;

        Builder(int x, int y, int width, int height, ResourceLocation textureLocation, Function<Builder, CompositeButton> factory) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.textureLocation = textureLocation;
            this.factory = factory;
        }

        public Builder setAtlasPos(int x, int y) {
            this.atlasX = x;
            this.atlasY = y;
            return this;
        }

        public Builder setHoverAtlasPos(int x, int y) {
            this.atlasXHover = x;
            this.atlasYHover = y;
            return this;
        }

        public Builder setInactiveAtlasPos(int x, int y) {
            this.atlasXInactive = x;
            this.atlasYInactive = y;
            return this;
        }

        public Builder setAction(Button.OnPress action) {
            this.action = action;
            return this;
        }

        public Builder setText(Component text) {
            this.text = text;
            return this;
        }

        public CompositeButton build() {
            return this.factory.apply(this);
        }
    }
}

