/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.model.geom;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;

public class ModModelLayers {
    private static final String DEFAULT_LAYER = "main";
    private static final Set<ModelLayerLocation> allModels = Sets.newHashSet();
    public static final ModelLayerLocation MUZZLE_FLASH = ModModelLayers.register("muzzle_flash");
    public static final ModelLayerLocation PARACHUTE = ModModelLayers.register("parachute");
    public static final ModelLayerLocation HANDCUFFS = ModModelLayers.register("handcuffs");
    public static final ModelLayerLocation C4_EXPLOSIVE = ModModelLayers.register("c4_explosive");
    public static final ModelLayerLocation CYLINDER_GRENADE = ModModelLayers.register("cylinder_grenade");
    public static final ModelLayerLocation FRAG_GRENADE = ModModelLayers.register("frag_grenade");
    public static final ModelLayerLocation SLIM_GRENADE = ModModelLayers.register("slim_grenade");

    private static ModelLayerLocation register(String model) {
        return ModModelLayers.register(model, DEFAULT_LAYER);
    }

    private static ModelLayerLocation register(String model, String layer) {
        ModelLayerLocation location = ModModelLayers.createLocation(model, layer);
        if (!allModels.add(location)) {
            throw new IllegalStateException("Duplicate registration for " + location);
        }
        return location;
    }

    private static ModelLayerLocation createLocation(String model, String layer) {
        return new ModelLayerLocation(new ResourceLocation("craftingdead", model), layer);
    }
}

