/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer;

import net.minecraft.util.Mth;

public class FloatSmoother {
    private final float acceleration;
    private volatile float targetValue;
    private volatile float remainingValue;
    private volatile float lastAmount;

    public FloatSmoother(float acceleration) {
        this.acceleration = acceleration;
    }

    public void add(float value) {
        this.targetValue += value;
    }

    public void reset() {
        this.targetValue = 0.0f;
        this.remainingValue = 0.0f;
        this.lastAmount = 0.0f;
    }

    public float getAndDecelerate(float deceleration) {
        float deltaAmount = this.targetValue - this.remainingValue;
        float lerpAmount = Mth.m_14179_((float)this.acceleration, (float)this.lastAmount, (float)deltaAmount);
        float signum = Math.signum(deltaAmount);
        if (signum * deltaAmount > signum * this.lastAmount) {
            deltaAmount = lerpAmount;
        }
        this.lastAmount = lerpAmount;
        float result = deltaAmount * Math.min(deceleration, 1.0f);
        this.remainingValue += result;
        if (Math.abs(result) < 0.001f) {
            result = 0.0f;
            this.reset();
        }
        return result;
    }
}

