/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.entity.grenade;

import com.craftingdead.core.client.model.geom.ModModelLayers;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class C4ExplosiveRenderer
extends EntityRenderer<Grenade> {
    private final ModelPart model;

    public C4ExplosiveRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = context.m_174023_(ModModelLayers.C4_EXPLOSIVE);
    }

    public void render(Grenade entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        if (!entity.hasStoppedMoving()) {
            float rotation = ((float)entity.f_19797_ + partialTicks) * 15.0f;
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(rotation));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(rotation));
        } else {
            poseStack.m_85845_(entity.getHitDirection().m_122406_());
        }
        VertexConsumer vertexConsumer = renderTypeBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.15f);
    }

    public ResourceLocation getTextureLocation(Grenade entity) {
        return new ResourceLocation("craftingdead", "textures/entity/grenade/" + entity.m_6095_().getRegistryName().m_135815_() + ".png");
    }
}

