/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.entity.layers;

import com.craftingdead.core.client.model.geom.ModModelLayers;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;

public class HandcuffsLayer<T extends Player, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("craftingdead", "textures/entity/handcuffs.png");
    private final ModelPart left;
    private final ModelPart right;
    private final ModelPart middle;

    public HandcuffsLayer(RenderLayerParent<T, M> parent, EntityModelSet entityModels) {
        super(parent);
        ModelPart root = entityModels.m_171103_(ModModelLayers.HANDCUFFS);
        this.left = root.m_171324_("left");
        this.right = root.m_171324_("right");
        this.middle = root.m_171324_("middle");
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageTicks, float headYaw, float headPitch) {
        PlayerExtension<T> player = PlayerExtension.get(livingEntity);
        if (player != null && player.isHandcuffed()) {
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_LOCATION));
            poseStack.m_85836_();
            float scale = 1.4f;
            poseStack.m_85841_(1.4f, 1.4f, 1.4f);
            poseStack.m_85836_();
            ((ArmedModel)this.m_117386_()).m_6002_(HumanoidArm.RIGHT, poseStack);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85837_(-0.32, -0.06, -0.4);
            this.right.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            poseStack.m_85836_();
            ((ArmedModel)this.m_117386_()).m_6002_(HumanoidArm.LEFT, poseStack);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            poseStack.m_85837_(0.07, -0.06, -0.4);
            this.left.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(-0.22, 0.34, 0.14);
            poseStack.m_85841_(1.3f, 1.0f, 1.0f);
            this.middle.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    public static LayerDefinition createHandcuffsBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(0.0f, 0.0f, 0.0f, 4.0f, 1.0f, 1.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        root.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-1.0f, -24.0f, 0.0f, 1.0f, 2.0f, 1.0f).m_171555_(false).m_171514_(0, 0).m_171480_().m_171481_(-3.0f, -22.0f, 0.0f, 2.0f, 1.0f, 1.0f).m_171555_(false).m_171514_(0, 0).m_171480_().m_171481_(-3.0f, -25.0f, 0.0f, 2.0f, 1.0f, 1.0f).m_171555_(false).m_171514_(0, 0).m_171480_().m_171481_(-4.0f, -24.0f, 0.0f, 1.0f, 2.0f, 1.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        root.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(5.0f, -22.0f, 0.0f, 2.0f, 1.0f, 1.0f).m_171555_(false).m_171514_(0, 0).m_171480_().m_171481_(7.0f, -24.0f, 0.0f, 1.0f, 2.0f, 1.0f).m_171555_(false).m_171514_(0, 0).m_171480_().m_171481_(5.0f, -25.0f, 0.0f, 2.0f, 1.0f, 1.0f).m_171555_(false).m_171514_(0, 0).m_171480_().m_171481_(4.0f, -24.0f, 0.0f, 1.0f, 2.0f, 1.0f).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }
}

