/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer.item;

import com.craftingdead.core.client.renderer.item.GunRenderer;
import com.craftingdead.core.client.renderer.item.GunRendererProperties;
import com.craftingdead.core.client.renderer.item.ItemRendererType;
import com.craftingdead.core.world.item.GunItem;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class ItemRendererTypes {
    public static final Codec<ItemRendererType<?, ?>> CODEC = ResourceLocation.f_135803_.flatXmap(ItemRendererTypes::getValueDataResult, ItemRendererTypes::getKeyDataResult);
    private static final BiMap<ResourceLocation, ItemRendererType<?, ?>> registry = HashBiMap.create();
    public static final ItemRendererType<GunItem, GunRendererProperties> GUN = ItemRendererTypes.register("gun", new ItemRendererType<GunItem, GunRendererProperties>(GunItem.class, GunRendererProperties.CODEC, GunRenderer::new));

    public static <T extends ItemRendererType<?, ?>> T register(String id, T itemRendererType) {
        return ItemRendererTypes.register(new ResourceLocation("craftingdead", id), itemRendererType);
    }

    public static <T extends ItemRendererType<?, ?>> T register(ResourceLocation id, T itemRendererType) {
        if (registry.put((Object)id, itemRendererType) != null) {
            throw new IllegalStateException("Duplicate key: " + id.toString());
        }
        return itemRendererType;
    }

    public static Optional<ItemRendererType<?, ?>> getValue(ResourceLocation key) {
        return Optional.ofNullable((ItemRendererType)registry.get((Object)key));
    }

    private static DataResult<? extends ItemRendererType<?, ?>> getValueDataResult(ResourceLocation key) {
        return ItemRendererTypes.getValue(key).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Key not found: " + key.toString())));
    }

    public static Optional<ResourceLocation> getKey(ItemRendererType<?, ?> value) {
        return Optional.ofNullable((ResourceLocation)registry.inverse().get(value));
    }

    private static DataResult<? extends ResourceLocation> getKeyDataResult(ItemRendererType<?, ?> value) {
        return ItemRendererTypes.getKey(value).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Value not found: " + value.getClass().getName())));
    }
}

