/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.sounds;

import com.mojang.logging.LogUtils;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;
import org.slf4j.Logger;

public class EffectsManager {
    private static final Logger logger = LogUtils.getLogger();
    private boolean initialisied = false;
    private final SoundEngine soundEngine;
    private int highpassSend;

    public EffectsManager(SoundEngine soundEngine) {
        this.soundEngine = soundEngine;
    }

    private void checkInit() {
        if (this.initialisied) {
            return;
        }
        long currentContext = ALC10.alcGetCurrentContext();
        long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
        if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
            logger.warn("EFX extension not found on current device");
            return;
        }
        logger.info("EFX extension recognised");
        this.highpassSend = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)this.highpassSend, (int)32769, (int)2);
        EffectsManager.checkLogError("Failed to generate high-pass send");
        this.initialisied = true;
    }

    public void setHighpassLevels(float highpassGain, float highpassCutoff) {
        this.checkInit();
        EXTEfx.alFilterf((int)this.highpassSend, (int)1, (float)highpassGain);
        EXTEfx.alFilterf((int)this.highpassSend, (int)2, (float)highpassCutoff);
    }

    public void setDirectHighpassForAll() {
        for (ChannelAccess.ChannelHandle entry : this.soundEngine.f_120226_.values()) {
            entry.m_120154_(source -> this.setDirectHighpass(source.f_83642_));
        }
    }

    public void setDirectHighpass(SoundInstance sound) {
        ChannelAccess.ChannelHandle entry = (ChannelAccess.ChannelHandle)this.soundEngine.f_120226_.get(sound);
        if (entry != null) {
            entry.m_120154_(source -> this.setDirectHighpass(source.f_83642_));
        }
    }

    public void setDirectHighpass(int source) {
        AL10.alSourcei((int)source, (int)131077, (int)this.highpassSend);
    }

    public void removeFilterForAll() {
        for (ChannelAccess.ChannelHandle entry : this.soundEngine.f_120226_.values()) {
            entry.m_120154_(source -> this.removeFilter(source.f_83642_));
        }
    }

    public void removeFilter(int source) {
        this.checkInit();
        AL10.alSourcei((int)source, (int)131077, (int)0);
    }

    private static boolean checkLogError(String errorMessage) {
        int error = AL10.alGetError();
        if (error == 0) {
            return false;
        }
        logger.warn(errorMessage + " OpenAL error " + (switch (error) {
            case 40961 -> "AL_INVALID_NAME";
            case 40962 -> "AL_INVALID_ENUM";
            case 40963 -> "AL_INVALID_VALUE";
            case 40964 -> "AL_INVALID_OPERATION";
            case 40965 -> "AL_OUT_OF_MEMORY";
            default -> Integer.toString(error);
        }));
        return true;
    }
}

