/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderProperties;
import org.jetbrains.annotations.Nullable;

public class RenderUtil {
    public static final Codec<Quaternion> QUATERNION_CODEC = Vector3f.f_176762_.xmap(Quaternion::m_175225_, Quaternion::m_175227_);
    public static final Codec<Transformation> TRANSFORMATION_MATRIX_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vector3f.f_176762_.optionalFieldOf("translation", (Object)new Vector3f()).xmap(vec -> {
        Vector3f scaledVec = vec.m_122281_();
        scaledVec.m_122261_(0.0625f);
        return scaledVec;
    }, scaledVec -> {
        Vector3f vec = scaledVec.m_122281_();
        vec.m_122261_(16.0f);
        return vec;
    }).forGetter(Transformation::m_175940_), (App)QUATERNION_CODEC.optionalFieldOf("rotation", (Object)Quaternion.f_80118_.m_80161_()).forGetter(Transformation::m_121105_), (App)Vector3f.f_176762_.optionalFieldOf("scale", (Object)new Vector3f(1.0f, 1.0f, 1.0f)).forGetter(Transformation::m_175941_), (App)QUATERNION_CODEC.optionalFieldOf("post-rotation", (Object)Quaternion.f_80118_.m_80161_()).forGetter(Transformation::m_175942_)).apply((Applicative)instance, Transformation::new));
    public static final int FULL_LIGHT = 0xF000F0;
    private static final Minecraft minecraft = Minecraft.m_91087_();

    public static void updateUniform(String name, float value, PostChain postChain) {
        for (PostPass pass : postChain.f_110009_) {
            pass.m_110074_().m_108960_(name).m_5985_(value);
        }
    }

    public static void updateUniform(String name, float[] value, PostChain postChain) {
        for (PostPass pass : postChain.f_110009_) {
            pass.m_110074_().m_108960_(name).m_5941_(value);
        }
    }

    @Nullable
    public static Vec2 projectToPlayerView(double x, double y, double z, float partialTicks) {
        Entity renderViewEntity;
        Camera activeRenderInfo = RenderUtil.minecraft.f_91063_.m_109153_();
        Vec3 cameraPos = activeRenderInfo.m_90583_();
        Quaternion cameraRotation = activeRenderInfo.m_90591_().m_80161_();
        cameraRotation.m_80157_();
        Vector3f result = new Vector3f((float)(cameraPos.f_82479_ - x), (float)(cameraPos.f_82480_ - y), (float)(cameraPos.f_82481_ - z));
        result.m_122251_(cameraRotation);
        if (RenderUtil.minecraft.f_91066_.f_92080_ && (renderViewEntity = minecraft.m_91288_()) instanceof Player) {
            Player player = (Player)renderViewEntity;
            float distanceWalkedModified = player.f_19787_;
            float changeInDistance = distanceWalkedModified - player.f_19867_;
            float lerpDistance = -(distanceWalkedModified + changeInDistance * partialTicks);
            float lerpYaw = Mth.m_14179_((float)partialTicks, (float)player.f_36099_, (float)player.f_36100_);
            Quaternion q2 = new Quaternion(Vector3f.f_122223_, Math.abs(Mth.m_14089_((float)(lerpDistance * (float)Math.PI - 0.2f)) * lerpYaw) * 5.0f, true);
            q2.m_80157_();
            result.m_122251_(q2);
            Quaternion q1 = new Quaternion(Vector3f.f_122227_, Mth.m_14031_((float)(lerpDistance * (float)Math.PI)) * lerpYaw * 3.0f, true);
            q1.m_80157_();
            result.m_122251_(q1);
            Vector3f bobTranslation = new Vector3f(Mth.m_14031_((float)(lerpDistance * (float)Math.PI)) * lerpYaw * 0.5f, -Math.abs(Mth.m_14089_((float)(lerpDistance * (float)Math.PI)) * lerpYaw), 0.0f);
            bobTranslation.setY(-bobTranslation.m_122260_());
            result.m_122253_(bobTranslation);
        }
        double fov = RenderUtil.minecraft.f_91063_.m_109141_(activeRenderInfo, partialTicks, true);
        float halfHeight = (float)minecraft.m_91268_().m_85446_() / 2.0f;
        float scale = halfHeight / (result.m_122269_() * (float)Math.tan(Math.toRadians(fov / 2.0)));
        return (double)result.m_122269_() > 0.0 ? null : new Vec2(-result.m_122239_() * scale, result.m_122260_() * scale);
    }

    public static boolean isInsideFrustum(Entity target, boolean firstPerson) {
        double viewerZ;
        double viewerY;
        Camera camera = RenderUtil.minecraft.f_91063_.m_109153_();
        Vec3 projectedViewVec3d = firstPerson ? target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0) : camera.m_90583_();
        double viewerX = projectedViewVec3d.m_7096_();
        if (!target.m_6000_(viewerX, viewerY = projectedViewVec3d.m_7098_(), viewerZ = projectedViewVec3d.m_7094_())) {
            return false;
        }
        AABB renderBoundingBox = target.m_6921_();
        if (renderBoundingBox.m_82392_() || renderBoundingBox.m_82309_() == 0.0) {
            renderBoundingBox = new AABB(target.m_20185_() - 2.0, target.m_20186_() - 2.0, target.m_20189_() - 2.0, target.m_20185_() + 2.0, target.m_20186_() + 2.0, target.m_20189_() + 2.0);
        }
        return RenderUtil.createFrustum(1.0f, firstPerson).m_113029_(renderBoundingBox);
    }

    public static Frustum createFrustum(float partialTicks, boolean firstPerson) {
        GameRenderer gameRenderer = RenderUtil.minecraft.f_91063_;
        LocalPlayer player = RenderUtil.minecraft.f_91074_;
        Camera camera = gameRenderer.m_109153_();
        Vec3 projectedViewVec3d = firstPerson ? player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0) : camera.m_90583_();
        double viewerX = projectedViewVec3d.m_7096_();
        double viewerY = projectedViewVec3d.m_7098_();
        double viewerZ = projectedViewVec3d.m_7094_();
        float pitch = firstPerson ? player.m_146909_() : camera.m_90589_();
        float yaw = firstPerson ? player.m_146908_() : camera.m_90590_();
        PoseStack poseStack = new PoseStack();
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(yaw + 180.0f));
        Matrix4f projectionMatrix = new Matrix4f();
        projectionMatrix.m_27624_();
        projectionMatrix.m_27644_(gameRenderer.m_172716_(gameRenderer.m_109141_(camera, partialTicks, true)));
        Frustum frustum = new Frustum(poseStack.m_85850_().m_85861_(), projectionMatrix);
        frustum.m_113002_(viewerX, viewerY, viewerZ);
        return frustum;
    }

    public static void fill(PoseStack poseStack, int x, int y, int width, int height, int colour) {
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)colour);
    }

    public static void fillGradient(PoseStack poseStack, float x, float y, float x2, float y2, int startColor, int endColor) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_85982_(pose, x, y2, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        builder.m_85982_(pose, x2, y2, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_85982_(pose, x2, y, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        builder.m_85982_(pose, x, y, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void applyPlayerCrouchRotation(PoseStack matrix) {
        matrix.m_85845_(Vector3f.f_122223_.m_122270_(0.5f));
        matrix.m_85837_(0.0, (double)0.2f, (double)-0.1f);
    }

    public static void blit(float x, float y, float width, float height, float textureX, float textureY) {
        RenderUtil.blit(x, y, x + width, y + height, textureX, textureY, textureX + width, textureY + height, 256.0f, 256.0f);
    }

    public static void blit(float x, float y, float x2, float y2, float textureX, float textureY, float textureX2, float textureY2, float width, float height) {
        float u = textureX / width;
        float u2 = textureX2 / width;
        float v = textureY / height;
        float v2 = textureY2 / height;
        RenderUtil.blit(x, y, x2, y2, u, v, u2, v2);
    }

    public static void blit(float x, float y, float width, float height) {
        RenderUtil.blit(x, y, x + width, y + height, 0.0f, 1.0f, 1.0f, 0.0f);
    }

    public static void blit(float x, float y, float x2, float y2, float u, float v, float u2, float v2) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder builder = tessellator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_5483_((double)x, (double)y2, 0.0).m_7421_(u, v).m_5752_();
        builder.m_5483_((double)x2, (double)y2, 0.0).m_7421_(u2, v).m_5752_();
        builder.m_5483_((double)x2, (double)y, 0.0).m_7421_(u2, v2).m_5752_();
        builder.m_5483_((double)x, (double)y, 0.0).m_7421_(u, v2).m_5752_();
        tessellator.m_85914_();
    }

    public static float getFitScale(float imageWidth, float imageHeight) {
        Window window = minecraft.m_91268_();
        float widthScale = (float)window.m_85443_() / imageWidth;
        float heightScale = (float)window.m_85444_() / imageHeight;
        float scale = imageHeight * widthScale < (float)window.m_85444_() ? heightScale : widthScale;
        return scale / (float)minecraft.m_91268_().m_85449_();
    }

    public static void renderGuiItem(ItemStack itemStack, int x, int y, int colour) {
        RenderUtil.renderGuiItem(itemStack, x, y, colour, minecraft.m_91291_().m_174264_(itemStack, null, null, 0), ItemTransforms.TransformType.GUI);
    }

    public static void renderGuiItem(ItemStack itemStack, int x, int y, int colour, ItemTransforms.TransformType transformType) {
        RenderUtil.renderGuiItem(itemStack, x, y, colour, minecraft.m_91291_().m_174264_(itemStack, null, null, 0), transformType);
    }

    public static void renderGuiItem(ItemStack itemStack, int x, int y, int colour, BakedModel bakedmodel, ItemTransforms.TransformType transformType) {
        boolean enable3dLight;
        RenderUtil.minecraft.f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, (double)(100.0f + RenderUtil.minecraft.m_91291_().f_115093_));
        poseStack.m_85837_(8.0, 8.0, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = enable3dLight = !bakedmodel.m_7547_();
        if (enable3dLight) {
            Lighting.m_84930_();
        }
        if (colour > -1) {
            RenderUtil.render(itemStack, transformType, false, new PoseStack(), (MultiBufferSource)bufferSource, colour, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        } else {
            minecraft.m_91291_().m_115143_(itemStack, transformType, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        }
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        if (enable3dLight) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void render(ItemStack p_115144_, ItemTransforms.TransformType p_115145_, boolean p_115146_, PoseStack p_115147_, MultiBufferSource p_115148_, int color, int p_115149_, int p_115150_, BakedModel p_115151_) {
        if (!p_115144_.m_41619_()) {
            boolean flag;
            p_115147_.m_85836_();
            boolean bl = flag = p_115145_ == ItemTransforms.TransformType.GUI || p_115145_ == ItemTransforms.TransformType.GROUND || p_115145_ == ItemTransforms.TransformType.FIXED;
            if (flag) {
                if (p_115144_.m_150930_(Items.f_42713_)) {
                    p_115151_ = minecraft.m_91291_().m_115103_().m_109393_().m_119422_(new ModelResourceLocation("minecraft:trident#inventory"));
                } else if (p_115144_.m_150930_(Items.f_151059_)) {
                    p_115151_ = minecraft.m_91291_().m_115103_().m_109393_().m_119422_(new ModelResourceLocation("minecraft:spyglass#inventory"));
                }
            }
            p_115151_ = ForgeHooksClient.handleCameraTransforms((PoseStack)p_115147_, (BakedModel)p_115151_, (ItemTransforms.TransformType)p_115145_, (boolean)p_115146_);
            p_115147_.m_85837_(-0.5, -0.5, -0.5);
            if (!(p_115151_.m_7521_() || p_115144_.m_150930_(Items.f_42713_) && !flag)) {
                Block block;
                boolean flag1 = p_115145_ != ItemTransforms.TransformType.GUI && !p_115145_.m_111841_() && p_115144_.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)p_115144_.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (p_115151_.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)minecraft.m_91291_(), (BakedModel)p_115151_, (ItemStack)p_115144_, (PoseStack)p_115147_, (MultiBufferSource)p_115148_, (int)p_115149_, (int)p_115150_, (boolean)flag1);
                } else {
                    VertexConsumer vertexconsumer;
                    RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)p_115144_, (boolean)flag1);
                    if (p_115144_.m_150930_(Items.f_42522_) && p_115144_.m_41790_()) {
                        p_115147_.m_85836_();
                        PoseStack.Pose posestack$pose = p_115147_.m_85850_();
                        if (p_115145_ == ItemTransforms.TransformType.GUI) {
                            posestack$pose.m_85861_().m_27630_(0.5f);
                        } else if (p_115145_.m_111841_()) {
                            posestack$pose.m_85861_().m_27630_(0.75f);
                        }
                        vertexconsumer = flag1 ? ItemRenderer.m_115207_((MultiBufferSource)p_115148_, (RenderType)rendertype, (PoseStack.Pose)posestack$pose) : ItemRenderer.m_115180_((MultiBufferSource)p_115148_, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                        p_115147_.m_85849_();
                    } else {
                        vertexconsumer = flag1 ? ItemRenderer.m_115222_((MultiBufferSource)p_115148_, (RenderType)rendertype, (boolean)true, (boolean)p_115144_.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)p_115148_, (RenderType)rendertype, (boolean)true, (boolean)p_115144_.m_41790_());
                    }
                    RenderUtil.renderModelLists(p_115151_, p_115144_, p_115149_, p_115150_, p_115147_, vertexconsumer, color);
                }
            } else {
                RenderProperties.get((ItemStack)p_115144_).getItemStackRenderer().m_108829_(p_115144_, p_115145_, p_115147_, p_115148_, p_115149_, p_115150_);
            }
            p_115147_.m_85849_();
        }
    }

    public static void renderModelLists(BakedModel p_115190_, ItemStack p_115191_, int p_115192_, int p_115193_, PoseStack p_115194_, VertexConsumer p_115195_, int color) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(i);
            RenderUtil.renderQuadList(p_115194_, p_115195_, p_115190_.m_6840_((BlockState)null, direction, random), p_115191_, p_115192_, p_115193_, color);
        }
        random.setSeed(i);
        RenderUtil.renderQuadList(p_115194_, p_115195_, p_115190_.m_6840_((BlockState)null, (Direction)null, random), p_115191_, p_115192_, p_115193_, color);
    }

    public static void renderQuadList(PoseStack p_115163_, VertexConsumer p_115164_, List<BakedQuad> p_115165_, ItemStack p_115166_, int p_115167_, int p_115168_, int color) {
        boolean flag = !p_115166_.m_41619_();
        PoseStack.Pose posestack$pose = p_115163_.m_85850_();
        for (BakedQuad bakedquad : p_115165_) {
            int i = color;
            if (flag && bakedquad.m_111304_()) {
                i = minecraft.getItemColors().m_92676_(p_115166_, bakedquad.m_111305_());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            p_115164_.putBulkData(posestack$pose, bakedquad, f, f1, f2, p_115167_, p_115168_, true);
        }
    }
}

