/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.Synched;
import com.craftingdead.core.network.message.play.SyncGunContainerSlotMessage;
import com.craftingdead.core.world.item.gun.Gun;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractContainerMenu.class})
public class AbstractContainerMenuMixin {
    private static final Logger logger = LogUtils.getLogger();
    @Shadow
    @Nullable
    private ContainerSynchronizer f_150397_;

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;matches(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z"), method={"synchronizeSlotToRemote"})
    private boolean matches(ItemStack lastStack, ItemStack currentStack, int slotIndex, ItemStack __, Supplier<ItemStack> coppiedStack) {
        if (this.f_150397_ == null) {
            return ItemStack.m_41728_((ItemStack)lastStack, (ItemStack)currentStack);
        }
        Class<?> clazz = this.f_150397_.getClass();
        if (clazz.isAnonymousClass() && clazz.getEnclosingClass() == ServerPlayer.class) {
            Object parent;
            try {
                parent = ObfuscationReflectionHelper.getPrivateValue(this.f_150397_.getClass(), (Object)this.f_150397_, (String)"f_143433_");
            }
            catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
                logger.error("Failed to reflect", (Throwable)e);
                return ItemStack.m_41728_((ItemStack)lastStack, (ItemStack)currentStack);
            }
            if (parent instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)parent;
                if (!currentStack.equals(lastStack, true)) {
                    return false;
                }
                AbstractContainerMenu container = (AbstractContainerMenu)this;
                currentStack.getCapability(Gun.CAPABILITY).filter(Synched::requiresSync).ifPresent(gun -> {
                    if (container == player.f_36095_) {
                        for (ItemStack equipmentStack : player.m_20158_()) {
                            if (equipmentStack != currentStack) continue;
                            return;
                        }
                    }
                    NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncGunContainerSlotMessage(player.m_142049_(), slotIndex, (Gun)gun, false));
                });
                return true;
            }
        }
        return ItemStack.m_41728_((ItemStack)lastStack, (ItemStack)currentStack);
    }
}

