/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.world.item.gun.Gun;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FriendlyByteBuf.class})
public class FriendlyByteBufMixin {
    @Inject(at={@At(value="RETURN")}, method={"Lnet/minecraft/network/FriendlyByteBuf;writeItemStack(Lnet/minecraft/world/item/ItemStack;Z)Lnet/minecraft/network/FriendlyByteBuf;"}, remap=false)
    private void writeItemStack(ItemStack itemStack, boolean limitedTag, CallbackInfoReturnable<FriendlyByteBuf> callbackInfo) {
        FriendlyByteBuf packetBuffer = (FriendlyByteBuf)this;
        Gun gun = (Gun)itemStack.getCapability(Gun.CAPABILITY).orElse(null);
        if (gun == null) {
            packetBuffer.m_130130_(0);
        } else {
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            gun.encode(data, true);
            packetBuffer.m_130130_(data.readableBytes());
            packetBuffer.writeBytes((ByteBuf)data);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"readItem"})
    private void readItem(CallbackInfoReturnable<ItemStack> callbackInfo) {
        FriendlyByteBuf packetBuffer = (FriendlyByteBuf)this;
        ItemStack itemStack = (ItemStack)callbackInfo.getReturnValue();
        byte[] data = new byte[packetBuffer.m_130242_()];
        if (data.length > 0) {
            packetBuffer.readBytes(data);
            Gun gun = (Gun)itemStack.getCapability(Gun.CAPABILITY).orElse(null);
            if (gun != null) {
                gun.decode(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data)));
            }
        }
    }
}

