/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.mixin;

import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.Synched;
import com.craftingdead.core.network.message.play.SyncGunEquipmentSlotMessage;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.Gun;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"isImmobile"}, cancellable=true)
    private void isImmobile(CallbackInfoReturnable<Boolean> callbackInfo) {
        LivingEntity livingEntity = (LivingEntity)this;
        livingEntity.getCapability(LivingExtension.CAPABILITY).ifPresent(living -> {
            if (!((Boolean)callbackInfo.getReturnValue()).booleanValue() && living.isMovementBlocked()) {
                callbackInfo.setReturnValue((Object)true);
            }
        });
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;matches(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z"), method={"collectEquipmentChanges"})
    private boolean matches(ItemStack currentStack, ItemStack lastStack) {
        if (!currentStack.equals(lastStack, true)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        for (EquipmentSlot slotType : EquipmentSlot.values()) {
            if (currentStack != livingEntity.m_6844_(slotType)) continue;
            currentStack.getCapability(Gun.CAPABILITY).filter(Synched::requiresSync).ifPresent(gun -> NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), (Object)new SyncGunEquipmentSlotMessage(livingEntity.m_142049_(), slotType, (Gun)gun, false)));
        }
        return true;
    }
}

