/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.particle;

import com.craftingdead.core.particle.ModParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class GrenadeSmokeParticleData
implements ParticleOptions {
    public static final Codec<GrenadeSmokeParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(GrenadeSmokeParticleData::getRed), (App)Codec.FLOAT.fieldOf("green").forGetter(GrenadeSmokeParticleData::getGreen), (App)Codec.FLOAT.fieldOf("blue").forGetter(GrenadeSmokeParticleData::getBlue), (App)Codec.FLOAT.fieldOf("scale").forGetter(GrenadeSmokeParticleData::getScale)).apply((Applicative)instance, GrenadeSmokeParticleData::new));
    public static final ParticleOptions.Deserializer<GrenadeSmokeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<GrenadeSmokeParticleData>(){

        public GrenadeSmokeParticleData fromCommand(ParticleType<GrenadeSmokeParticleData> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float red = stringReader.readFloat();
            stringReader.expect(' ');
            float green = stringReader.readFloat();
            stringReader.expect(' ');
            float blue = stringReader.readFloat();
            stringReader.expect(' ');
            float scale = stringReader.readFloat();
            return new GrenadeSmokeParticleData(red, green, blue, scale);
        }

        public GrenadeSmokeParticleData fromNetwork(ParticleType<GrenadeSmokeParticleData> particleType, FriendlyByteBuf packetBuffer) {
            return new GrenadeSmokeParticleData(packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat());
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;

    public GrenadeSmokeParticleData(float red, float green, float blue, float scale) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.scale = scale;
    }

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeFloat(this.red);
        packetBuffer.writeFloat(this.green);
        packetBuffer.writeFloat(this.blue);
        packetBuffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", this.m_6012_().getRegistryName(), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.scale));
    }

    public ParticleType<GrenadeSmokeParticleData> m_6012_() {
        return (ParticleType)ModParticleTypes.GRENADE_SMOKE.get();
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getScale() {
        return this.scale;
    }
}

