/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;

public class RayTraceUtil {
    public static Optional<EntityHitResult> rayTraceEntities(Entity fromEntity) {
        AttributeInstance attributeInstance;
        if (fromEntity instanceof Player) {
            Player player = (Player)fromEntity;
            attributeInstance = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        } else {
            attributeInstance = null;
        }
        AttributeInstance reachDistanceAttribute = attributeInstance;
        double distance = reachDistanceAttribute == null ? 4.0 : reachDistanceAttribute.m_22135_();
        Vec3 startPos = fromEntity.m_20299_(1.0f);
        Vec3 look = fromEntity.m_20252_(1.0f);
        Vec3 scaledLook = look.m_82490_(distance);
        Vec3 endPos = startPos.m_82549_(scaledLook);
        return Optional.ofNullable(ProjectileUtil.m_37287_((Entity)fromEntity, (Vec3)startPos, (Vec3)endPos, (AABB)fromEntity.m_142469_().m_82369_(scaledLook).m_82377_(1.0, 1.0, 1.0), EntitySelector.f_20402_.and(EntitySelector.f_20406_), (double)(distance * distance)));
    }

    public static Optional<? extends HitResult> rayTrace(Entity fromEntity, double distance, float partialTick, float pitchOffset, float yawOffset) {
        Vec3 startPos = fromEntity.m_20299_(partialTick);
        Vec3 look = RayTraceUtil.calculateViewVector(fromEntity.m_5686_(partialTick) + pitchOffset, fromEntity.m_5675_(partialTick) + yawOffset);
        Vec3 scaledLook = look.m_82490_(distance);
        Vec3 endPos = startPos.m_82549_(scaledLook);
        Optional<BlockHitResult> blockHitResult = RayTraceUtil.rayTraceBlocks(startPos, distance, look, fromEntity.m_183503_());
        double sqrDistance = blockHitResult.isPresent() ? blockHitResult.get().m_82450_().m_82557_(startPos) : distance * distance;
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)fromEntity, (Vec3)startPos, (Vec3)endPos, (AABB)fromEntity.m_142469_().m_82369_(scaledLook).m_82377_(1.0, 1.0, 1.0), EntitySelector.f_20402_.and(EntitySelector.f_20406_), (double)sqrDistance);
        return entityHitResult == null ? blockHitResult : Optional.of(entityHitResult);
    }

    public static Optional<BlockHitResult> rayTraceBlocks(Vec3 startPos, double distance, Vec3 look, Level level) {
        return RayTraceUtil.rayTraceBlocks(startPos, distance, look, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, level);
    }

    public static Optional<BlockHitResult> rayTraceBlocks(Vec3 startPos, double distance, Vec3 look, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, Level level) {
        Vec3 currentPos = startPos;
        Vec3 endPos = startPos.m_82549_(look.m_82490_(distance));
        BlockHitResult hitResult = null;
        BlockPos lastBlockPos = null;
        while (!(currentPos.m_82554_(startPos) >= distance)) {
            ClipContext context = new ClipContext(currentPos, endPos, blockMode, fluidMode, null);
            hitResult = level.m_45547_(context);
            if (hitResult == null) continue;
            BlockPos blockPos = hitResult.m_82425_();
            if (lastBlockPos != null && lastBlockPos.equals((Object)blockPos)) break;
            lastBlockPos = blockPos;
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_60815_()) break;
            Vec3 hitPos = hitResult.m_82450_();
            VoxelShape shape = context.m_45694_(blockState, (BlockGetter)level, blockPos);
            if (shape.m_83281_()) continue;
            AABB bounds = shape.m_83215_();
            double xDist = look.m_7096_() < 0.0 ? hitPos.m_7096_() - bounds.f_82288_ - (double)blockPos.m_123341_() : (double)blockPos.m_123341_() - hitPos.m_7096_() + bounds.f_82291_;
            double yDist = look.m_7098_() < 0.0 ? hitPos.m_7098_() - bounds.f_82289_ - (double)blockPos.m_123342_() : (double)blockPos.m_123342_() - hitPos.m_7098_() + bounds.f_82292_;
            double zDist = look.m_7094_() < 0.0 ? hitPos.m_7094_() - bounds.f_82290_ - (double)blockPos.m_123343_() : (double)blockPos.m_123343_() - hitPos.m_7094_() + bounds.f_82293_;
            double xRayDist = Math.abs(look.m_7096_()) != 0.0 ? xDist / Math.abs(look.m_7096_()) : Double.MAX_VALUE;
            double yRayDist = Math.abs(look.m_7098_()) != 0.0 ? yDist / Math.abs(look.m_7098_()) : Double.MAX_VALUE;
            double zRayDist = Math.abs(look.m_7094_()) != 0.0 ? zDist / Math.abs(look.m_7094_()) : Double.MAX_VALUE;
            double rayDist = Math.min(xRayDist, Math.min(zRayDist, yRayDist));
            currentPos = hitPos.m_82549_(look.m_82490_(rayDist));
        }
        return Optional.ofNullable(hitResult);
    }

    public static Vec3 calculateViewVector(float pitch, float yaw) {
        float pitchRad = pitch * ((float)Math.PI / 180);
        float yawRad = -yaw * ((float)Math.PI / 180);
        float yawCos = Mth.m_14089_((float)yawRad);
        float yawSin = Mth.m_14031_((float)yawRad);
        float pitchCos = Mth.m_14089_((float)pitchRad);
        float pitchSin = Mth.m_14031_((float)pitchRad);
        return new Vec3((double)(yawSin * pitchCos), (double)(-pitchSin), (double)(yawCos * pitchCos));
    }
}

