/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.world.action.ActionType;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public interface ProgressBar {
    public Component getMessage();

    public Optional<Component> getSubMessage();

    public float getProgress(float var1);

    public static ProgressBar create(final ActionType<?> actionType, final @Nullable Component subMessage, final FloatUnaryOperator progress) {
        return new ProgressBar(){

            @Override
            public Component getMessage() {
                return new TranslatableComponent(actionType.makeDescriptionId() + ".message");
            }

            @Override
            public Optional<Component> getSubMessage() {
                return Optional.ofNullable(subMessage);
            }

            @Override
            public float getProgress(float partialTick) {
                return progress.apply(partialTick);
            }
        };
    }
}

