/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface TargetSelector<T extends LivingExtension<?, ?>> {
    public static final TargetSelector<?> SELF_ONLY = (performer, target) -> Optional.of(performer);
    public static final TargetSelector<?> OTHERS_ONLY = (performer, target) -> Optional.ofNullable(target);
    public static final TargetSelector<?> SELF_OR_OTHERS = (performer, target) -> Optional.ofNullable(target == null ? performer : target);

    public Optional<T> select(LivingExtension<?, ?> var1, @Nullable LivingExtension<?, ?> var2);

    default public TargetSelector<PlayerExtension<?>> players() {
        return (performer, target) -> this.select(performer, target).filter((? super T l) -> l instanceof PlayerExtension).map(l -> (PlayerExtension)l);
    }

    default public <E extends LivingEntity> TargetSelector<LivingExtension<E, ?>> ofEntityType(EntityType<E> type) {
        Objects.requireNonNull(type);
        return (performer, target) -> this.select(performer, target).filter((? super T living) -> living.getEntity().m_6095_() == type).map(living -> living);
    }

    default public <E extends LivingEntity> TargetSelector<LivingExtension<E, ?>> ofEntityType(Class<E> clazz) {
        Objects.requireNonNull(clazz);
        return (performer, target) -> this.select(performer, target).filter((? super T living) -> clazz.isInstance(living.getEntity())).map(living -> living);
    }

    default public TargetSelector<?> hasEffect(Supplier<MobEffect> effect) {
        return this.filter(living -> living.getEntity().m_21023_((MobEffect)effect.get()));
    }

    default public TargetSelector<T> filter(Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        return (performer, target) -> this.select(performer, target).filter(predicate);
    }
}

