/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.item;

import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.TargetSelector;
import com.craftingdead.core.world.action.item.EntityItemAction;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public final class EntityItemActionType<T extends LivingExtension<?, ?>>
extends ItemActionType<EntityItemAction<T>> {
    private final TargetSelector<T> targetSelector;
    private final List<EffectAction> effects;
    @Nullable
    private final CustomAction<T> customAction;

    private EntityItemActionType(Builder<T> builder) {
        super(builder);
        this.targetSelector = builder.targetSelector;
        this.effects = builder.effects;
        this.customAction = builder.customAction;
    }

    public TargetSelector<T> getTargetSelector() {
        return this.targetSelector;
    }

    public List<EffectAction> getEffects() {
        return this.effects;
    }

    @Nullable
    public CustomAction<T> getCustomAction() {
        return this.customAction;
    }

    @Override
    public void encode(EntityItemAction<T> action, FriendlyByteBuf out) {
        out.m_130068_((Enum)action.getHand());
        out.m_130130_(action.getSelectedTarget().getEntity().m_142049_());
    }

    @Override
    public EntityItemAction<T> decode(LivingExtension<?, ?> performer, FriendlyByteBuf in) {
        InteractionHand hand = (InteractionHand)in.m_130066_(InteractionHand.class);
        int targetId = in.m_130242_();
        Entity target = performer.getLevel().m_6815_(targetId);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            return new EntityItemAction(hand, this, performer, LivingExtension.getOrThrow(livingTarget));
        }
        throw new IllegalStateException("Invalid target: " + target);
    }

    @Override
    public Optional<Action> createEntityAction(LivingExtension<?, ?> performer, LivingExtension<?, ?> target, InteractionHand hand) {
        LivingExtension selectedTarget = this.getTargetSelector().select(performer, target).orElse(null);
        return Optional.of(new EntityItemAction<LivingExtension>(hand, this, performer, selectedTarget));
    }

    @Override
    public Optional<Action> createAction(LivingExtension<?, ?> performer, InteractionHand hand) {
        LivingExtension selectedTarget = this.getTargetSelector().select(performer, null).orElse(null);
        return Optional.of(new EntityItemAction<LivingExtension>(hand, this, performer, selectedTarget));
    }

    public static <T extends LivingExtension<?, ?>> Builder<T> builder(TargetSelector<T> targetSelector) {
        return new Builder<T>(targetSelector);
    }

    public static final class Builder<T extends LivingExtension<?, ?>>
    extends ItemActionType.Builder<Builder<T>> {
        private final TargetSelector<T> targetSelector;
        private final List<EffectAction> effects = new ArrayList<EffectAction>();
        @Nullable
        private CustomAction<T> customAction;

        private Builder(TargetSelector<T> targetSelector) {
            this.targetSelector = targetSelector;
        }

        public Builder<T> effect(Supplier<MobEffectInstance> effect) {
            return this.effect(effect, 1.0f);
        }

        public Builder<T> effect(Supplier<MobEffectInstance> effect, float chance) {
            this.effects.add(new EffectAction(effect, chance));
            return this;
        }

        public Builder<T> customAction(BiConsumer<LivingExtension<?, ?>, T> customAction) {
            return this.customAction(customAction, 1.0f);
        }

        public Builder<T> customAction(BiConsumer<LivingExtension<?, ?>, T> customAction, float chance) {
            this.customAction = new CustomAction<T>(customAction, chance);
            return this;
        }

        @Override
        public EntityItemActionType<?> build() {
            return new EntityItemActionType(this);
        }
    }

    public record CustomAction<T extends LivingExtension<?, ?>>(BiConsumer<LivingExtension<?, ?>, T> consumer, float chance) {
    }

    public record EffectAction(Supplier<MobEffectInstance> effect, float chance) {
    }
}

