/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.reload;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.event.CollectMagazineItemHandlers;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.action.reload.AbstractReloadAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MagazineReloadAction
extends AbstractReloadAction {
    private final MagazineAmmoProvider ammoProvider;
    private ItemStack newMagazineStack;
    private MagazineLocation magazineLocation;

    public MagazineReloadAction(LivingExtension<?, ?> performer) {
        super(performer);
        AmmoProvider ammoProvider = this.gun.getAmmoProvider();
        if (!(ammoProvider instanceof MagazineAmmoProvider)) {
            throw new IllegalStateException("No MagazineAmmoProvider present");
        }
        this.ammoProvider = (MagazineAmmoProvider)ammoProvider;
    }

    @Override
    public ActionType<?> getType() {
        return (ActionType)ActionTypes.MAGAZINE_RELOAD.get();
    }

    @Override
    public boolean start(boolean simulate) {
        Optional<MagazineLocation> result = this.findMagazine(this.getPerformer());
        if (!result.isPresent()) {
            return false;
        }
        if (!simulate) {
            this.magazineLocation = result.get();
            this.newMagazineStack = this.magazineLocation.itemHandler.extractItem(this.magazineLocation.slot, 1, false);
        }
        return super.start(simulate);
    }

    @Override
    protected void loadNewMagazineStack(boolean displayOnly) {
        this.ammoProvider.setMagazineStack(this.newMagazineStack);
        if (!(displayOnly || this.oldMagazineStack.m_41619_() || !(this.getPerformer().getEntity() instanceof Player) || this.oldMagazineStack.getCapability(Magazine.CAPABILITY).map(Magazine::isEmpty).orElse(true).booleanValue() && ((Boolean)CraftingDead.serverConfig.reloadDestroyMagWhenEmpty.get()).booleanValue())) {
            ((Player)this.getPerformer().getEntity()).m_36356_(this.oldMagazineStack);
        }
    }

    @Override
    protected void revert() {
        this.ammoProvider.setMagazineStack(this.oldMagazineStack);
        ItemStack remainingStack = this.magazineLocation.itemHandler().insertItem(this.magazineLocation.slot(), this.newMagazineStack, false);
        this.getPerformer().getEntity().m_19983_(remainingStack);
    }

    private List<IItemHandler> collectItemHandlers(LivingExtension<?, ?> living) {
        ImmutableList.Builder builder = ImmutableList.builder();
        CollectMagazineItemHandlers event = new CollectMagazineItemHandlers(living);
        MinecraftForge.EVENT_BUS.post((Event)event);
        builder.addAll(event.getItemHandlers());
        living.getItemHandler().getStackInSlot(ModEquipmentSlot.VEST.getIndex()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        living.getItemHandler().getStackInSlot(ModEquipmentSlot.BACKPACK.getIndex()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        living.getEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private Optional<MagazineLocation> findMagazine(LivingExtension<?, ?> living) {
        for (IItemHandler itemHandler : this.collectItemHandlers(living)) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (!this.gun.getAcceptedMagazines().contains(itemStack.m_41720_()) || itemStack.getCapability(Magazine.CAPABILITY).map(Magazine::isEmpty).orElse(true).booleanValue()) continue;
                return Optional.of(new MagazineLocation(itemHandler, i));
            }
        }
        return Optional.empty();
    }

    private record MagazineLocation(IItemHandler itemHandler, int slot) {
    }
}

