/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.damagesource;

import com.craftingdead.core.world.damagesource.KillFeedDamageSource;
import com.craftingdead.core.world.damagesource.KillFeedEntry;
import com.craftingdead.core.world.entity.grenade.Grenade;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ModDamageSource {
    public static final String BULLET_HEADSHOT_DAMAGE_TYPE = "bullet.headshot";
    public static final String BULLET_BODY_DAMAGE_TYPE = "bullet";

    public static DamageSource causeGunDamage(LivingEntity source, ItemStack gunStack, boolean headshot) {
        return new KillFeedDamageSource(headshot ? BULLET_HEADSHOT_DAMAGE_TYPE : BULLET_BODY_DAMAGE_TYPE, source, gunStack, headshot ? KillFeedEntry.Type.HEADSHOT : KillFeedEntry.Type.NONE).m_19380_().m_19366_().m_19375_();
    }

    public static DamageSource grenade(Grenade grenade, @Nullable Entity thrower) {
        return new IndirectEntityDamageSource("grenade", (Entity)grenade, thrower).m_19375_();
    }

    public static DamageSource causeUnscaledExplosionDamage(@Nullable LivingEntity source) {
        return (source != null ? new EntityDamageSource("explosion.player", (Entity)source) : new DamageSource("explosion")).m_19375_();
    }

    public static boolean causeDamageWithoutKnockback(Entity victim, DamageSource source, float amount) {
        if (victim instanceof LivingEntity) {
            LivingEntity livingHit = (LivingEntity)victim;
            AttributeInstance livingResistance = livingHit.m_21051_(Attributes.f_22278_);
            double previousResistance = livingResistance.m_22115_();
            livingResistance.m_22100_(2.147483647E9);
            boolean attackResult = livingHit.m_6469_(source, amount);
            livingResistance.m_22100_(previousResistance);
            return attackResult;
        }
        return victim.m_6469_(source, amount);
    }
}

