/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.jetbrains.annotations.Nullable;

public abstract class BounceableProjectileEntity
extends Entity
implements IEntityAdditionalSpawnData {
    @Nullable
    private UUID sourceId;
    private BlockState blockStanding;
    private boolean stoppedMoving;
    private int totalTicksInAir;
    private int motionStopCount;
    private Direction hitDirection = Direction.UP;
    protected boolean isSticky;

    public BounceableProjectileEntity(EntityType<? extends BounceableProjectileEntity> type, Level level) {
        super(type, level);
    }

    public BounceableProjectileEntity(EntityType<? extends BounceableProjectileEntity> type, double x, double y, double z, Level level) {
        this(type, level);
        this.m_6034_(x, y, z);
    }

    public BounceableProjectileEntity(EntityType<? extends BounceableProjectileEntity> type, LivingEntity throwerEntity, Level level) {
        this(type, throwerEntity.m_20185_(), throwerEntity.m_20188_(), throwerEntity.m_20189_(), level);
        this.setSource((Entity)throwerEntity);
    }

    public void setSource(Entity source) {
        this.setSourceId(source.m_142081_());
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setSticky(boolean isSticky) {
        this.isSticky = isSticky;
    }

    public void m_8119_() {
        super.m_8119_();
        BlockPos currentBlockPos = this.m_142538_();
        BlockState currentBlockState = this.f_19853_.m_8055_(currentBlockPos);
        if (this.stoppedMoving) {
            boolean shouldMove;
            if (this.blockStanding == null) {
                this.blockStanding = currentBlockState;
            }
            boolean notCollided = this.blockStanding != currentBlockState && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
            boolean bl = shouldMove = !this.m_20184_().equals((Object)Vec3.f_82478_) || notCollided;
            if (shouldMove) {
                this.stoppedMoving = false;
                this.blockStanding = null;
            }
        }
        if (!this.stoppedMoving) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, 0.04, 0.0));
            }
            ++this.totalTicksInAir;
            Vec3 position = this.m_20182_();
            Vec3 motionBeforeHit = this.m_20184_();
            BlockHitResult blockRayTraceResult = this.f_19853_.m_45547_(new ClipContext(position, position.m_82549_(motionBeforeHit), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            Vec3 nextBounceMotion = null;
            if (blockRayTraceResult.m_6662_() != HitResult.Type.MISS) {
                BlockState blockHitState = this.f_19853_.m_8055_(blockRayTraceResult.m_82425_());
                Vec3 difference = blockRayTraceResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_20256_(difference);
                Vec3 vec = difference.m_82541_().m_82490_(0.05);
                this.m_6034_(this.m_20185_() - vec.f_82479_, this.m_20186_() - vec.f_82480_, this.m_20189_() - vec.f_82481_);
                Optional<Float> optional = this.getBounceFactor(blockRayTraceResult);
                if (optional.isPresent()) {
                    float bounceFactor = optional.get().floatValue();
                    switch (blockRayTraceResult.m_82434_()) {
                        case UP: {
                            nextBounceMotion = Math.abs(motionBeforeHit.f_82480_) > 0.1 ? motionBeforeHit.m_82542_(0.63, (double)(-bounceFactor), 0.63) : Vec3.f_82478_;
                            break;
                        }
                        case DOWN: {
                            nextBounceMotion = motionBeforeHit.m_82542_(0.9, (double)(-bounceFactor), 0.9);
                            break;
                        }
                        case WEST: 
                        case EAST: {
                            nextBounceMotion = motionBeforeHit.m_82542_((double)(-bounceFactor), 0.9, 0.9);
                            break;
                        }
                        case SOUTH: 
                        case NORTH: {
                            nextBounceMotion = motionBeforeHit.m_82542_(0.9, 0.9, (double)(-bounceFactor));
                            break;
                        }
                    }
                } else {
                    nextBounceMotion = Vec3.f_82478_;
                }
                this.onSurfaceHit(blockRayTraceResult);
                if (this.m_6084_() && (nextBounceMotion != null && blockRayTraceResult.m_82434_() == Direction.UP || this.isSticky) && (nextBounceMotion.m_82553_() < 0.1 || this.isSticky)) {
                    nextBounceMotion = Vec3.f_82478_;
                    this.stoppedMoving = true;
                    this.blockStanding = blockHitState;
                    this.onMotionStop(++this.motionStopCount);
                    this.hitDirection = blockRayTraceResult.m_82434_();
                }
            }
            Vec3 currentMotion = this.m_20184_();
            double nextX = this.m_20185_() + currentMotion.f_82479_;
            double nextY = this.m_20186_() + currentMotion.f_82480_;
            double nextZ = this.m_20189_() + currentMotion.f_82481_;
            this.m_6034_(nextX, nextY, nextZ);
            this.m_20101_();
            if (nextBounceMotion != null) {
                this.m_20256_(nextBounceMotion);
            }
        }
    }

    public abstract void onSurfaceHit(BlockHitResult var1);

    public abstract void onMotionStop(int var1);

    public void shootFromEntity(Entity entity, float x, float y, float z, float force, float p_184538_6_) {
        float f = -Mth.m_14031_((float)(y * ((float)Math.PI / 180))) * Mth.m_14089_((float)(x * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(y * ((float)Math.PI / 180))) * Mth.m_14089_((float)(x * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, force, p_184538_6_);
        Vec3 vec3d = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3d.f_82479_, entity.m_20096_() ? 0.0 : vec3d.f_82480_, vec3d.f_82481_));
    }

    public void shoot(double x, double y, double z, float force, float p_70186_8_) {
        Vec3 vec = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.f_19796_.nextGaussian() * (double)0.0075f * (double)p_70186_8_).m_82490_((double)force);
        this.m_20256_(vec);
        float f = Mth.m_14116_((float)((float)this.m_20238_(vec)));
        this.m_146922_((float)(Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public int getTotalTicksInAir() {
        return this.totalTicksInAir;
    }

    public BlockState getBlockStanding() {
        return this.blockStanding;
    }

    public boolean hasStoppedMoving() {
        return this.stoppedMoving;
    }

    public int getMotionStopCount() {
        return this.motionStopCount;
    }

    protected float getGravityVelocity() {
        return 1.04f;
    }

    public Optional<Float> getBounceFactor(BlockHitResult blockRayTraceResult) {
        return Optional.of(Float.valueOf(0.375f));
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.sourceId != null) {
            compound.m_128362_("sourceId", this.sourceId);
        }
        compound.m_128379_("stoppedMoving", this.stoppedMoving);
        compound.m_128405_("motionStopCount", this.motionStopCount);
        compound.m_128379_("isSticky", this.isSticky);
        compound.m_128359_("hitDirection", this.hitDirection.m_7912_());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("sourceId")) {
            this.sourceId = compound.m_128342_("sourceId");
        }
        this.stoppedMoving = compound.m_128471_("stoppedMoving");
        this.motionStopCount = compound.m_128451_("motionStopCount");
        this.isSticky = compound.m_128471_("isSticky");
        Direction hitDirection = Direction.m_122402_((String)compound.m_128461_("hitDirection"));
        if (hitDirection != null) {
            this.hitDirection = hitDirection;
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.stoppedMoving);
        buffer.writeInt(this.totalTicksInAir);
        buffer.writeInt(this.motionStopCount);
        buffer.writeBoolean(this.isSticky);
        buffer.m_130068_((Enum)this.hitDirection);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.stoppedMoving = buffer.readBoolean();
        this.totalTicksInAir = buffer.readInt();
        this.motionStopCount = buffer.readInt();
        this.isSticky = buffer.readBoolean();
        this.hitDirection = (Direction)buffer.m_130066_(Direction.class);
    }

    public Optional<Entity> getSource() {
        Optional<Entity> optional;
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            optional = Optional.ofNullable(level2.m_8791_(this.sourceId));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Direction getHitDirection() {
        return this.hitDirection;
    }
}

