/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.ai;

import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.grenade.Grenade;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class FollowAttractiveGrenadeGoal
extends Goal {
    private final Mob goalOwner;
    private final double moveSpeedMultiplier;
    private Grenade grenade;
    private int delayCounter;

    public FollowAttractiveGrenadeGoal(Mob goalOwner, double moveSpeedMultiplier) {
        this.goalOwner = goalOwner;
        this.moveSpeedMultiplier = moveSpeedMultiplier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.goalOwner.m_21023_((MobEffect)ModMobEffects.FLASH_BLINDNESS.get())) {
            return false;
        }
        List list = this.goalOwner.f_19853_.m_45976_(Grenade.class, this.goalOwner.m_142469_().m_82377_(20.0, 5.0, 20.0));
        Grenade nearestGrenade = null;
        double lastSqDistance = Double.MAX_VALUE;
        for (Grenade grenade : list) {
            double sqDistance;
            if (!grenade.isAttracting() || !((sqDistance = this.goalOwner.m_20280_((Entity)grenade)) <= lastSqDistance)) continue;
            lastSqDistance = sqDistance;
            nearestGrenade = grenade;
        }
        if (nearestGrenade == null || !nearestGrenade.m_6084_()) {
            return false;
        }
        this.grenade = nearestGrenade;
        return true;
    }

    public boolean m_8045_() {
        if (!this.grenade.m_6084_()) {
            return false;
        }
        if (this.goalOwner.m_21023_((MobEffect)ModMobEffects.FLASH_BLINDNESS.get())) {
            return false;
        }
        if (this.grenade.f_19853_ != this.goalOwner.f_19853_) {
            return false;
        }
        return this.goalOwner.m_20280_((Entity)this.grenade) <= 256.0;
    }

    public void m_8056_() {
        this.delayCounter = 0;
    }

    public void m_8041_() {
        this.grenade = null;
    }

    public void m_8037_() {
        this.goalOwner.m_21563_().m_24946_(this.grenade.m_20185_(), this.grenade.m_20188_(), this.grenade.m_20189_());
        if (--this.delayCounter <= 0) {
            this.delayCounter = 5 + this.goalOwner.m_21187_().nextInt(10);
            this.goalOwner.m_21573_().m_5624_((Entity)this.grenade, this.moveSpeedMultiplier);
        }
    }
}

